/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import javax.annotation.Nonnull;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.PathParserException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;

public final class PathUtils {
    private PathUtils() {
    }

    public static String getContextPath(URL url) {
        String path = url.getPath();
        if (path == null) {
            return "";
        }
        int len = path.length();
        if (len == 0) {
            return "";
        }
        String ifName = url.getParameter("interface");
        if (ifName == null || path.equalsIgnoreCase(ifName)) {
            return "";
        }
        int index = path.lastIndexOf(ifName);
        if (index + ifName.length() == len) {
            return path.substring(0, index - 1);
        }
        return path.charAt(len - 1) == '/' ? path.substring(0, len - 1) : path;
    }

    public static boolean isDirectPath(@Nonnull String path) {
        boolean braceStart = false;
        int len = path.length();
        block5: for (int i = 0; i < len; ++i) {
            switch (path.charAt(i)) {
                case '*': 
                case '?': {
                    return false;
                }
                case '{': {
                    braceStart = true;
                    continue block5;
                }
                case '}': {
                    if (!braceStart) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    public static String combine(@Nonnull String path1, @Nonnull String path2) {
        boolean slash2;
        if (path1.isEmpty()) {
            return path2.isEmpty() ? "" : path2;
        }
        if (path2.isEmpty()) {
            return path1;
        }
        int len1 = path1.length();
        char last1 = path1.charAt(len1 - 1);
        if (len1 == 1) {
            if (last1 == '/' || last1 == '*') {
                return path2;
            }
        } else if (path1.indexOf(123) == -1) {
            if (path1.indexOf(42) != -1 && PathExpression.parse(path1).match(path2) != null) {
                return path2;
            }
            int starDotPos1 = path1.lastIndexOf("*.");
            if (starDotPos1 > -1) {
                boolean ext2All;
                String ext2;
                String file2;
                String ext1 = path1.substring(starDotPos1 + 1);
                int dotPos2 = path2.lastIndexOf(46);
                if (dotPos2 == -1) {
                    file2 = path2;
                    ext2 = "";
                } else {
                    file2 = path2.substring(0, dotPos2);
                    ext2 = path2.substring(dotPos2);
                }
                boolean ext1All = ext1.equals(".*") || ext1.isEmpty();
                boolean bl = ext2All = ext2.equals(".*") || ext2.isEmpty();
                if (!ext1All && !ext2All) {
                    throw new PathParserException(Messages.CANNOT_COMBINE_PATHS, path1, path2);
                }
                return file2 + (ext1All ? ext2 : ext1);
            }
        }
        if (last1 == '*' && path1.charAt(len1 - 2) == '/') {
            path1 = path1.substring(0, len1 - 2);
        }
        boolean slash1 = last1 == '/';
        boolean bl = slash2 = path2.charAt(0) == '/';
        if (slash1) {
            return slash2 ? path1 + path2.substring(1) : path1 + path2;
        }
        if (slash2) {
            return path1 + path2;
        }
        return path1 + '/' + path2;
    }

    public static String normalize(String contextPath, String path) {
        if (StringUtils.isEmpty((String)contextPath)) {
            return StringUtils.isEmpty((String)path) ? "/" : PathUtils.normalize(path);
        }
        if (StringUtils.isEmpty((String)path)) {
            return PathUtils.normalize(contextPath);
        }
        if (path.charAt(0) != '/') {
            contextPath = contextPath + '/';
        }
        return PathUtils.normalize(contextPath + path);
    }

    public static String normalize(@Nonnull String path) {
        int len = path.length();
        if (len == 0) {
            return "/";
        }
        int state = 0;
        int start = -1;
        int end = 0;
        StringBuilder buf = null;
        block25: for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            block0 : switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block25;
                }
                case '/': {
                    switch (state) {
                        case 2: {
                            if (start != -1) {
                                if (buf == null) {
                                    buf = new StringBuilder(len);
                                }
                                buf.append(path, start, i);
                            }
                            start = -1;
                            continue block25;
                        }
                        case 3: {
                            state = 2;
                            if (buf == null) {
                                buf = new StringBuilder(len);
                            }
                            buf.append(path, start, i - 1);
                            start = -1;
                            continue block25;
                        }
                        case 4: {
                            state = 2;
                            if (buf == null) {
                                buf = new StringBuilder(len);
                            }
                            if (end > 2) {
                                int index;
                                buf.append(path, start, i - 2);
                                int bLen = buf.length();
                                if (bLen > 1 && !"/../".equals(buf.substring(index = buf.lastIndexOf("/", bLen - 2)))) {
                                    buf.setLength(index + 1);
                                    start = -1;
                                    continue block25;
                                }
                            }
                            buf.append(path, start, i + 1);
                            start = -1;
                            continue block25;
                        }
                        default: {
                            state = 2;
                            break;
                        }
                    }
                    break;
                }
                case '.': {
                    switch (state) {
                        case 0: {
                            if (buf == null) {
                                buf = new StringBuilder(len);
                            }
                            buf.append('/');
                        }
                        case 2: {
                            state = 3;
                            break block0;
                        }
                        case 3: {
                            state = 4;
                            break block0;
                        }
                        case 4: {
                            state = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case '#': 
                case '?': {
                    break block25;
                }
                default: {
                    switch (state) {
                        case 0: {
                            if (buf == null) {
                                buf = new StringBuilder(len);
                            }
                            buf.append('/');
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            state = 1;
                            break block0;
                        }
                    }
                }
            }
            if (start == -1) {
                start = i;
            }
            end = i;
        }
        switch (state) {
            case 3: {
                --end;
                break;
            }
            case 4: {
                if (buf == null) {
                    buf = new StringBuilder(len);
                }
                if (end <= 2) break;
                buf.append(path, start, end - 2);
                buf.setLength(buf.lastIndexOf("/") + 1);
                start = -1;
                break;
            }
        }
        if (buf == null) {
            return start == -1 ? path : path.substring(start, end + 1);
        }
        if (start != -1) {
            buf.append(path, start, end + 1);
        }
        return buf.toString();
    }

    private static interface State {
        public static final int INITIAL = 0;
        public static final int NORMAL = 1;
        public static final int SLASH = 2;
        public static final int DOT = 3;
        public static final int DOT_DOT = 4;
    }
}

