/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtension;

public final class RestUtils {
    private RestUtils() {
    }

    public static boolean hasPlaceholder(String text) {
        if (text == null) {
            return false;
        }
        int len = text.length();
        if (len < 4) {
            return false;
        }
        int state = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '$') {
                state = 1;
                continue;
            }
            if (c == '{') {
                if (state != true) continue;
                if (text.charAt(i + 1) != '$') {
                    return false;
                }
                state = 2;
                continue;
            }
            if (c != '}' || state != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean isMaybeJSONObject(String str) {
        int i;
        if (str == null) {
            return false;
        }
        int n = str.length();
        if (n < 3) {
            return false;
        }
        char expected = '\u0000';
        for (i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == '{') {
                expected = '}';
                break;
            }
            return false;
        }
        for (int j = n - 1; j > i; --j) {
            char c = str.charAt(j);
            if (Character.isWhitespace(c)) continue;
            return c == expected;
        }
        return false;
    }

    public static int getPriority(Object obj) {
        int priority;
        if (obj instanceof Prioritized && (priority = ((Prioritized)obj).getPriority()) != 0) {
            return priority;
        }
        Activate activate = obj.getClass().getAnnotation(Activate.class);
        return activate == null ? 0 : activate.order();
    }

    public static String[] getPattens(Object obj) {
        return obj instanceof RestExtension ? ((RestExtension)obj).getPatterns() : null;
    }
}

