/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.nested.RestConfig;
import org.apache.dubbo.remoting.http12.rest.Mapping;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.cors.CorsUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.basic.BasicRestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate
public class BasicRequestMappingResolver
implements RequestMappingResolver {
    private final RestToolKit toolKit;
    private RestConfig restConfig;
    private CorsMeta globalCorsMeta;

    public BasicRequestMappingResolver(FrameworkModel frameworkModel) {
        this.toolKit = new BasicRestToolKit(frameworkModel);
    }

    @Override
    public RestToolKit getRestToolKit() {
        return this.toolKit;
    }

    @Override
    public void setRestConfig(RestConfig restConfig) {
        this.restConfig = restConfig;
    }

    @Override
    public boolean accept(MethodMeta methodMeta) {
        AnnotationMeta<Mapping> mapping = methodMeta.findAnnotation(Mapping.class);
        return mapping != null ? mapping.getAnnotation().enabled() : methodMeta.getMethodDescriptor() != null;
    }

    @Override
    public RequestMapping resolve(ServiceMeta serviceMeta) {
        AnnotationMeta<Mapping> mapping = serviceMeta.findAnnotation(Mapping.class);
        RequestMapping.Builder builder = this.builder(mapping);
        String[] paths = BasicRequestMappingResolver.resolvePaths(mapping);
        if (paths.length == 0) {
            builder.path(serviceMeta.getServiceInterface());
        } else {
            builder.path(paths);
        }
        return builder.name(serviceMeta.getType().getSimpleName()).contextPath(serviceMeta.getContextPath()).build();
    }

    @Override
    public RequestMapping resolve(MethodMeta methodMeta) {
        Boolean enabled;
        Method method = methodMeta.getMethod();
        AnnotationMeta<Mapping> mapping = methodMeta.findAnnotation(Mapping.class);
        if (mapping != null ? !mapping.getAnnotation().enabled() : (enabled = this.restConfig.getEnableDefaultMapping()) != null && enabled == false) {
            return null;
        }
        RequestMapping.Builder builder = this.builder(mapping);
        String[] paths = BasicRequestMappingResolver.resolvePaths(mapping);
        if (paths.length == 0) {
            builder.path('/' + method.getName()).sig(TypeUtils.buildSig(method));
        } else {
            builder.path(paths);
        }
        ServiceMeta serviceMeta = methodMeta.getServiceMeta();
        if (this.globalCorsMeta == null) {
            this.globalCorsMeta = CorsUtils.getGlobalCorsMeta(this.restConfig);
        }
        return builder.name(method.getName()).service(serviceMeta.getServiceGroup(), serviceMeta.getServiceVersion()).cors(this.globalCorsMeta).build();
    }

    private RequestMapping.Builder builder(AnnotationMeta<?> mapping) {
        RequestMapping.Builder builder = RequestMapping.builder();
        if (mapping == null) {
            return builder;
        }
        builder.method(mapping.getStringArray("method")).param(mapping.getStringArray("params")).header(mapping.getStringArray("headers")).consume(mapping.getStringArray("consumes")).produce(mapping.getStringArray("produces"));
        return builder;
    }

    private static String[] resolvePaths(AnnotationMeta<?> mapping) {
        if (mapping == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        String[] paths = mapping.getStringArray("path");
        if (paths.length > 0) {
            return paths;
        }
        return mapping.getValueArray();
    }
}

