/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.rpc.executor.AbstractIsolationExecutorSupport;
import org.apache.dubbo.rpc.protocol.tri.RequestPath;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class TripleIsolationExecutorSupport
extends AbstractIsolationExecutorSupport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TripleIsolationExecutorSupport.class);

    public TripleIsolationExecutorSupport(URL url) {
        super(url);
    }

    protected String getServiceKey(Object data) {
        if (data instanceof RequestMetadata) {
            RequestMetadata httpMetadata = (RequestMetadata)data;
            RequestPath path = RequestPath.parse(httpMetadata.path());
            if (path == null) {
                return null;
            }
            HttpHeaders headers = httpMetadata.headers();
            return URL.buildKey((String)path.getServiceInterface(), (String)TripleIsolationExecutorSupport.getHeader(headers, TripleHeaderEnum.SERVICE_GROUP, "rest-service-group"), (String)TripleIsolationExecutorSupport.getHeader(headers, TripleHeaderEnum.SERVICE_VERSION, "rest-service-version"));
        }
        if (data instanceof URL) {
            return ((URL)data).getServiceKey();
        }
        return null;
    }

    private static String getHeader(HttpHeaders headers, TripleHeaderEnum en, String key) {
        String value = headers.getFirst(en.getKey());
        if (value == null) {
            value = headers.getFirst((CharSequence)key);
        }
        return value;
    }
}

