/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;

public class TriplePathResolver
implements PathResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriplePathResolver.class);
    private final Map<String, Invoker<?>> mapping = CollectionUtils.newConcurrentHashMap();
    private final Map<String, Boolean> nativeStubs = CollectionUtils.newConcurrentHashMap();

    public void register(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        String serviceKey = url.getServiceKey();
        String serviceInterface = url.getServiceModel().getServiceModel().getInterfaceName();
        this.register0(serviceKey, serviceInterface, invoker, url);
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        String fallbackPath = path.substring(0, index + 1) + serviceInterface;
        this.register0(URL.buildKey((String)path, (String)url.getGroup(), (String)url.getVersion()), fallbackPath, invoker, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void register0(String path, String fallbackPath, Invoker<?> invoker, URL url) {
        Invoker<?> previous = this.mapping.put(path, invoker);
        if (previous != null) {
            if (!path.equals(fallbackPath)) throw new IllegalStateException(String.format("Already exists an invoker[%s] on path[%s], failed to add invoker[%s], please use a unique path.", previous.getUrl(), path, url));
            LOGGER.info("Already exists an invoker[{}] on path[{}], dubbo will override with invoker[{}]", new Object[]{previous.getUrl(), path, url});
        } else {
            LOGGER.debug("Register triple grpc mapping: '{}' -> invoker[{}], service=[{}]", new Object[]{path, url, ClassUtils.toShortString((Object)url.getServiceModel().getProxyObject())});
        }
        if (!TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT || path.equals(fallbackPath)) return;
        previous = this.mapping.putIfAbsent(fallbackPath, invoker);
        if (previous != null) {
            LOGGER.info("Already exists an invoker[{}] on path[{}], dubbo will skip override with invoker[{}]", new Object[]{previous.getUrl(), fallbackPath, url});
            return;
        } else {
            LOGGER.info("Register fallback triple grpc mapping: '{}' -> invoker[{}], service=[{}]", new Object[]{fallbackPath, url, ClassUtils.toShortString((Object)url.getServiceModel().getProxyObject())});
        }
    }

    public void unregister(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        this.mapping.remove(url.getServiceKey());
        if (TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT) {
            this.mapping.remove(url.getServiceModel().getServiceModel().getInterfaceName());
        }
    }

    public Invoker<?> add(String path, Invoker<?> invoker) {
        return this.mapping.put(path, invoker);
    }

    public Invoker<?> addIfAbsent(String path, Invoker<?> invoker) {
        return this.mapping.putIfAbsent(path, invoker);
    }

    public Invoker<?> resolve(String path, String group, String version) {
        Invoker<?> invoker = this.mapping.get(URL.buildKey((String)path, (String)group, (String)version));
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT && (invoker = this.mapping.get(URL.buildKey((String)path, (String)group, (String)"1.0.0"))) == null) {
            invoker = this.mapping.get(path);
        }
        return invoker;
    }

    public boolean hasNativeStub(String path) {
        return this.nativeStubs.containsKey(path);
    }

    public void addNativeStub(String path) {
        this.nativeStubs.put(path, Boolean.TRUE);
    }

    public void remove(String path) {
        this.mapping.remove(path);
    }

    public void destroy() {
        this.mapping.clear();
    }
}

