/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class GrpcUtils {
    private GrpcUtils() {
    }

    public static Long parseTimeoutToMills(String timeoutVal) {
        if (StringUtils.isEmpty((String)timeoutVal) || StringUtils.isContains((String)timeoutVal, (String)"null")) {
            return null;
        }
        long value = Long.parseLong(timeoutVal.substring(0, timeoutVal.length() - 1));
        char unit = timeoutVal.charAt(timeoutVal.length() - 1);
        switch (unit) {
            case 'n': {
                return TimeUnit.NANOSECONDS.toMillis(value);
            }
            case 'u': {
                return TimeUnit.MICROSECONDS.toMillis(value);
            }
            case 'm': {
                return value;
            }
            case 'S': {
                return TimeUnit.SECONDS.toMillis(value);
            }
            case 'M': {
                return TimeUnit.MINUTES.toMillis(value);
            }
            case 'H': {
                return TimeUnit.HOURS.toMillis(value);
            }
        }
        return null;
    }

    public static String getTimeoutHeaderValue(Long timeout, TimeUnit unit) {
        long timeoutNanos = timeout;
        if (unit != TimeUnit.NANOSECONDS) {
            timeoutNanos = unit.toNanos(timeout);
        }
        long cutoff = 100000000L;
        if (timeoutNanos < 0L) {
            throw new IllegalArgumentException("Timeout too small");
        }
        if (timeoutNanos < 100000000L) {
            return timeoutNanos + "n";
        }
        if (timeoutNanos < 100000000000L) {
            return TimeUnit.NANOSECONDS.toMicros(timeoutNanos) + "u";
        }
        if (timeoutNanos < 100000000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(timeoutNanos) + "m";
        }
        if (timeoutNanos < 100000000000000000L) {
            return TimeUnit.NANOSECONDS.toSeconds(timeoutNanos) + "S";
        }
        if (timeoutNanos < 6000000000000000000L) {
            return TimeUnit.NANOSECONDS.toMinutes(timeoutNanos) + "M";
        }
        return TimeUnit.NANOSECONDS.toHours(timeoutNanos) + "H";
    }

    public static boolean isGrpcRequest(String contentType) {
        return contentType != null && contentType.startsWith(MediaType.APPLICATION_GRPC.getName());
    }
}

