/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import java.util.concurrent.Executor;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.command.CreateStreamQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.stream.AbstractTripleClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleStreamChannelFuture;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleCommandOutBoundHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleHttp2ClientResponseHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleWriteQueue;

public final class Http2TripleClientStream
extends AbstractTripleClientStream {
    public Http2TripleClientStream(FrameworkModel frameworkModel, Executor executor, Channel parent, ClientStream.Listener listener, TripleWriteQueue writeQueue) {
        super(frameworkModel, executor, writeQueue, listener, parent);
    }

    public Http2TripleClientStream(FrameworkModel frameworkModel, Executor executor, TripleWriteQueue writeQueue, ClientStream.Listener listener, Http2StreamChannel http2StreamChannel) {
        super(frameworkModel, executor, writeQueue, listener, http2StreamChannel);
    }

    @Override
    protected TripleStreamChannelFuture initStreamChannel(Channel parent) {
        Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(parent);
        bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) {
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new TripleCommandOutBoundHandler()}).addLast(new ChannelHandler[]{new TripleHttp2ClientResponseHandler(Http2TripleClientStream.this.createTransportListener())});
            }
        });
        TripleStreamChannelFuture streamChannelFuture = new TripleStreamChannelFuture(parent);
        this.writeQueue.enqueue(CreateStreamQueueCommand.create(bootstrap, streamChannelFuture));
        return streamChannelFuture;
    }
}

