/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2StreamServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class Http2UnaryServerChannelObserver
extends Http2StreamServerChannelObserver {
    private static final FluentLogger LOGGER = FluentLogger.of(Http2UnaryServerChannelObserver.class);

    public Http2UnaryServerChannelObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        super(frameworkModel, h2StreamChannel);
    }

    protected void doOnNext(Object data) throws Throwable {
        int statusCode = this.resolveStatusCode(data);
        HttpOutputMessage message = this.buildMessage(statusCode, data);
        HttpMetadata metadata = this.buildMetadata(statusCode, data, null, message);
        this.customizeTrailers(metadata.headers(), null);
        this.sendMetadata(metadata);
        this.sendMessage(message);
    }

    protected void doOnError(Throwable throwable) throws Throwable {
        HttpOutputMessage message;
        int statusCode = this.resolveErrorStatusCode(throwable);
        ErrorResponse data = this.buildErrorResponse(statusCode, throwable);
        try {
            message = this.buildMessage(statusCode, data);
        }
        catch (Throwable t) {
            LOGGER.internalError("Failed to build message", t);
            message = this.encodeHttpOutputMessage(data);
        }
        HttpMetadata metadata = this.buildMetadata(statusCode, data, throwable, message);
        this.customizeTrailers(metadata.headers(), throwable);
        this.sendMetadata(metadata);
        this.sendMessage(message);
    }

    protected void customizeTrailers(HttpHeaders headers, Throwable throwable) {
        StreamUtils.putHeaders(headers, this.getResponseAttachments(), TripleProtocol.CONVERT_NO_LOWER_HEADER);
        super.customizeTrailers(headers, throwable);
    }

    protected void doOnCompleted(Throwable throwable) {
    }

    protected HttpOutputMessage encodeHttpOutputMessage(Object data) {
        return ((H2StreamChannel)this.getHttpChannel()).newOutputMessage(true);
    }

    protected HttpMetadata encodeHttpMetadata(boolean endStream) {
        return new Http2MetadataFrame((HttpHeaders)new NettyHttpHeaders((Headers)new DefaultHttp2Headers(false, 8)), endStream);
    }
}

