/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;

public final class PathCondition
implements Condition<PathCondition, HttpRequest> {
    private final String contextPath;
    private final Set<String> paths;
    private List<PathExpression> expressions;

    public PathCondition(String contextPath, String ... paths) {
        this.contextPath = contextPath;
        this.paths = new LinkedHashSet<String>(Arrays.asList(paths));
    }

    private PathCondition(String contextPath, Set<String> paths) {
        this.contextPath = contextPath;
        this.paths = paths;
    }

    public PathCondition(PathExpression path) {
        this.contextPath = null;
        this.paths = Collections.singleton(path.getPath());
        this.expressions = Collections.singletonList(path);
    }

    public List<PathExpression> getExpressions() {
        List<PathExpression> expressions = this.expressions;
        if (expressions == null) {
            expressions = new ArrayList<PathExpression>();
            for (String path : this.paths) {
                expressions.add(PathExpression.parse(PathUtils.normalize(this.contextPath, path)));
            }
            this.expressions = expressions;
        }
        return expressions;
    }

    @Override
    public PathCondition combine(PathCondition other) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.paths.isEmpty()) {
            if (other.paths.isEmpty()) {
                result.add("");
            } else {
                result.addAll(other.paths);
            }
        } else if (other.paths.isEmpty()) {
            result.addAll(this.paths);
        } else {
            for (String left : this.paths) {
                for (String right : other.paths) {
                    result.add(PathUtils.combine(left, right));
                }
            }
        }
        return new PathCondition(this.contextPath, result);
    }

    @Override
    public PathCondition match(HttpRequest request) {
        ArrayList<PathExpression> matches = null;
        String path = request.rawPath();
        List<PathExpression> expressions = this.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            PathExpression expression = expressions.get(i);
            Map<String, String> variables = expression.match(path);
            if (variables == null) continue;
            if (matches == null) {
                matches = new ArrayList<PathExpression>();
            }
            matches.add(expression);
        }
        if (matches != null) {
            if (matches.size() > 1) {
                Collections.sort(matches);
            }
            Set result = CollectionUtils.newLinkedHashSet((int)matches.size());
            int size2 = matches.size();
            for (int i = 0; i < size2; ++i) {
                result.add(((PathExpression)matches.get(i)).getPath());
            }
            return new PathCondition(this.contextPath, result);
        }
        return null;
    }

    @Override
    public int compareTo(PathCondition other, HttpRequest request) {
        String lookupPath = (String)request.attribute("org.springframework.web.util.UrlPathHelper.PATH");
        Iterator<PathExpression> it = this.getExpressions().iterator();
        Iterator<PathExpression> oit = other.getExpressions().iterator();
        while (it.hasNext() && oit.hasNext()) {
            int result = it.next().compareTo(oit.next(), lookupPath);
            if (result == 0) continue;
            return result;
        }
        if (it.hasNext()) {
            return -1;
        }
        if (oit.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return 31 * this.paths.hashCode() + this.contextPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != PathCondition.class) {
            return false;
        }
        PathCondition other = (PathCondition)obj;
        return this.paths.equals(other.paths) && Objects.equals(this.contextPath, other.contextPath);
    }

    public String toString() {
        return "PathCondition{paths=" + this.paths + '}';
    }
}

