/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.security.cert;

import java.util.Objects;

public class CertConfig {
    private final String remoteAddress;
    private final String envType;
    private final String caCertPath;
    private final String oidcTokenPath;
    private final int refreshInterval;

    public CertConfig(String remoteAddress, String envType, String caCertPath, String oidcTokenPath) {
        this(remoteAddress, envType, caCertPath, oidcTokenPath, 30000);
    }

    public CertConfig(String remoteAddress, String envType, String caCertPath, String oidcTokenPath, int refreshInterval) {
        this.remoteAddress = remoteAddress;
        this.envType = envType;
        this.caCertPath = caCertPath;
        this.oidcTokenPath = oidcTokenPath;
        this.refreshInterval = refreshInterval;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getEnvType() {
        return this.envType;
    }

    public String getCaCertPath() {
        return this.caCertPath;
    }

    public String getOidcTokenPath() {
        return this.oidcTokenPath;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertConfig that = (CertConfig)o;
        return Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.envType, that.envType) && Objects.equals(this.caCertPath, that.caCertPath) && Objects.equals(this.oidcTokenPath, that.oidcTokenPath);
    }

    public int hashCode() {
        return Objects.hash(this.remoteAddress, this.envType, this.caCertPath, this.oidcTokenPath);
    }
}

