/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.PojoUtils;

public class FastJsonObjectInput
implements ObjectInput {
    private final BufferedReader reader;

    public FastJsonObjectInput(InputStream in) {
        this(new InputStreamReader(in));
    }

    public FastJsonObjectInput(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public boolean readBool() throws IOException {
        return this.read(Boolean.TYPE);
    }

    public byte readByte() throws IOException {
        return this.read(Byte.TYPE);
    }

    public short readShort() throws IOException {
        return this.read(Short.TYPE);
    }

    public int readInt() throws IOException {
        return this.read(Integer.TYPE);
    }

    public long readLong() throws IOException {
        return this.read(Long.TYPE);
    }

    public float readFloat() throws IOException {
        return this.read(Float.TYPE).floatValue();
    }

    public double readDouble() throws IOException {
        return this.read(Double.TYPE);
    }

    public String readUTF() throws IOException {
        return this.read(String.class);
    }

    public byte[] readBytes() throws IOException {
        return this.readLine().getBytes();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        String json = this.readLine();
        return JSON.parse((String)json);
    }

    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return this.read(cls);
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        T value = this.readObject(cls);
        return (T)PojoUtils.realize(value, cls, (Type)type);
    }

    private String readLine() throws IOException, EOFException {
        String line = this.reader.readLine();
        if (line == null || line.trim().length() == 0) {
            throw new EOFException();
        }
        return line;
    }

    private <T> T read(Class<T> cls) throws IOException {
        String json = this.readLine();
        return (T)JSON.parseObject((String)json, cls);
    }
}

