/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fst;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.fst.FstFactory;
import org.nustaq.serialization.FSTObjectInput;

public class FstObjectInput
implements ObjectInput {
    private FSTObjectInput input;

    public FstObjectInput(InputStream inputStream) {
        this.input = FstFactory.getDefaultFactory().getObjectInput(inputStream);
    }

    public boolean readBool() throws IOException {
        return this.input.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    public short readShort() throws IOException {
        return this.input.readShort();
    }

    public int readInt() throws IOException {
        return this.input.readInt();
    }

    public long readLong() throws IOException {
        return this.input.readLong();
    }

    public float readFloat() throws IOException {
        return this.input.readFloat();
    }

    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    public byte[] readBytes() throws IOException {
        int len = this.input.readInt();
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] b = new byte[len];
        this.input.readFully(b);
        return b;
    }

    public String readUTF() throws IOException {
        return this.input.readUTF();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.input.readObject();
    }

    public <T> T readObject(Class<T> clazz) throws IOException, ClassNotFoundException {
        try {
            return (T)this.input.readObject(new Class[]{clazz});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T> T readObject(Class<T> clazz, Type type) throws IOException, ClassNotFoundException {
        try {
            return (T)this.input.readObject(new Class[]{clazz});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

