/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.nativejava;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.java.JavaSerialization;
import org.apache.dubbo.common.serialize.nativejava.NativeJavaObjectInput;
import org.apache.dubbo.common.serialize.nativejava.NativeJavaObjectOutput;

public class NativeJavaSerialization
implements Serialization {
    private static final Logger logger = LoggerFactory.getLogger(JavaSerialization.class);
    private static final AtomicBoolean warn = new AtomicBoolean(false);

    public byte getContentTypeId() {
        return 7;
    }

    public String getContentType() {
        return "x-application/nativejava";
    }

    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        if (warn.compareAndSet(false, true)) {
            logger.error("Java serialization is unsafe. Dubbo Team do not recommend anyone to use it.If you still want to use it, please follow [JEP 290](https://openjdk.java.net/jeps/290)to set serialization filter to prevent deserialization leak.");
        }
        return new NativeJavaObjectOutput(output);
    }

    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        if (warn.compareAndSet(false, true)) {
            logger.error("Java serialization is unsafe. Dubbo Team do not recommend anyone to use it.If you still want to use it, please follow [JEP 290](https://openjdk.java.net/jeps/290)to set serialization filter to prevent deserialization leak.");
        }
        return new NativeJavaObjectInput(input);
    }
}

