/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.lang.reflect.Method;

public class ProtobufUtils {
    static boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return GeneratedMessageV3.class.isAssignableFrom(clazz);
    }

    static <T> T deserialize(String json, Class<T> requestClass) throws InvalidProtocolBufferException {
        GeneratedMessageV3.Builder builder;
        try {
            builder = ProtobufUtils.getMessageBuilder(requestClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Get google protobuf message builder from " + requestClass.getName() + "failed", e);
        }
        JsonFormat.parser().merge(json, (Message.Builder)builder);
        return (T)builder.build();
    }

    static String serialize(Object value) throws InvalidProtocolBufferException {
        JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace();
        return printer.print((MessageOrBuilder)value);
    }

    private static GeneratedMessageV3.Builder getMessageBuilder(Class<?> requestType) throws Exception {
        Method method = requestType.getMethod("newBuilder", new Class[0]);
        return (GeneratedMessageV3.Builder)method.invoke(null, null);
    }
}

