/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protostuff;

import io.protostuff.GraphIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.protostuff.Wrapper;
import org.apache.dubbo.common.serialize.protostuff.utils.WrapperUtils;

public class ProtostuffObjectOutput
implements ObjectOutput {
    private LinkedBuffer buffer = LinkedBuffer.allocate();
    private DataOutputStream dos;

    public ProtostuffObjectOutput(OutputStream outputStream) {
        this.dos = new DataOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object obj) throws IOException {
        byte[] classNameBytes;
        byte[] bytes;
        try {
            if (WrapperUtils.needWrapper(obj)) {
                Schema schema = RuntimeSchema.getSchema(Wrapper.class);
                Wrapper<Object> wrapper = new Wrapper<Object>(obj);
                bytes = GraphIOUtil.toByteArray(wrapper, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = Wrapper.class.getName().getBytes();
            } else {
                Schema schema = RuntimeSchema.getSchema(obj.getClass());
                bytes = GraphIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)this.buffer);
                classNameBytes = obj.getClass().getName().getBytes();
            }
        }
        finally {
            this.buffer.clear();
        }
        this.dos.writeInt(classNameBytes.length);
        this.dos.writeInt(bytes.length);
        this.dos.write(classNameBytes);
        this.dos.write(bytes);
    }

    public void writeBool(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.dos.writeByte(v);
    }

    public void writeShort(short v) throws IOException {
        this.dos.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    public void writeUTF(String v) throws IOException {
        byte[] bytes = v.getBytes();
        this.dos.writeInt(bytes.length);
        this.dos.write(bytes);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.dos.writeInt(v.length);
        this.dos.write(v);
    }

    public void writeBytes(byte[] v, int off, int len) throws IOException {
        this.dos.writeInt(len);
        byte[] bytes = new byte[len];
        System.arraycopy(v, off, bytes, 0, len);
        this.dos.write(bytes);
    }

    public void flushBuffer() throws IOException {
        this.dos.flush();
    }
}

