/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.mvc;

import java.util.Map;
import java.util.SortedMap;
import org.apache.dubbo.spring.boot.actuate.endpoint.DubboEndpoint;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboConfigsMetadata;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboPropertiesMetadata;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboReferencesMetadata;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboServicesMetadata;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboShutdownMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.DeferredResult;

public class DubboMvcEndpoint
extends EndpointMvcAdapter {
    public static final String DUBBO_SHUTDOWN_ENDPOINT_URI = "/shutdown";
    public static final String DUBBO_CONFIGS_ENDPOINT_URI = "/configs";
    public static final String DUBBO_SERVICES_ENDPOINT_URI = "/services";
    public static final String DUBBO_REFERENCES_ENDPOINT_URI = "/references";
    public static final String DUBBO_PROPERTIES_ENDPOINT_URI = "/properties";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private DubboShutdownMetadata dubboShutdownMetadata;
    @Autowired
    private DubboConfigsMetadata dubboConfigsMetadata;
    @Autowired
    private DubboServicesMetadata dubboServicesMetadata;
    @Autowired
    private DubboReferencesMetadata dubboReferencesMetadata;
    @Autowired
    private DubboPropertiesMetadata dubboPropertiesMetadata;

    public DubboMvcEndpoint(DubboEndpoint dubboEndpoint) {
        super((Endpoint)dubboEndpoint);
    }

    @RequestMapping(value={"/shutdown"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DeferredResult shutdown() throws Exception {
        Map shutdownCountData = this.dubboShutdownMetadata.shutdown();
        return new DeferredResult(null, (Object)shutdownCountData);
    }

    @RequestMapping(value={"/configs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Map<String, Object>>> configs() {
        return this.dubboConfigsMetadata.configs();
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Object>> services() {
        return this.dubboServicesMetadata.services();
    }

    @RequestMapping(value={"/references"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Object>> references() {
        return this.dubboReferencesMetadata.references();
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SortedMap<String, Object> properties() {
        return this.dubboPropertiesMetadata.properties();
    }
}

