/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.condition;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

class CompatibleOnEnabledEndpointCondition
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatibleOnEnabledEndpointCondition.class);
    static String CONDITION_CLASS_NAME_OLD = "org.springframework.boot.actuate.autoconfigure.endpoint.condition.OnEnabledEndpointCondition";
    static String CONDITION_CLASS_NAME_NEW = "org.springframework.boot.actuate.autoconfigure.endpoint.condition.OnAvailableEndpointCondition";

    CompatibleOnEnabledEndpointCondition() {
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class cls;
        ClassLoader classLoader = context.getClassLoader();
        if (ClassUtils.isPresent((String)CONDITION_CLASS_NAME_OLD, (ClassLoader)classLoader) && Condition.class.isAssignableFrom(cls = ClassUtils.resolveClassName((String)CONDITION_CLASS_NAME_OLD, (ClassLoader)classLoader))) {
            Condition condition = (Condition)Condition.class.cast(BeanUtils.instantiateClass((Class)cls));
            return condition.matches(context, metadata);
        }
        if (ClassUtils.isPresent((String)CONDITION_CLASS_NAME_NEW, (ClassLoader)classLoader)) {
            return true;
        }
        LOGGER.warn(String.format("No condition class found, Dubbo Health Endpoint [%s] will not expose", metadata));
        return false;
    }
}

