/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint;

import java.util.Map;
import org.apache.dubbo.qos.command.ActuatorExecutor;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.boot.actuate.endpoint.DubboActuatorProperties;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.DubboMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.lang.Nullable;

@Endpoint(id="dubbo")
public class DubboQosEndpoints {
    @Autowired
    private ApplicationModel applicationModel;
    @Autowired
    private DubboMetadata dubboMetadata;
    @Autowired
    private DubboActuatorProperties dubboActuatorProperties;

    @ReadOperation
    public Map<String, Object> invoke() {
        return this.dubboMetadata.invoke();
    }

    @ReadOperation
    public String handleCommand(@Selector String command, @Nullable String[] args) {
        if (this.dubboActuatorProperties.isEnabled(command.toLowerCase())) {
            ActuatorExecutor actuatorExecutor = (ActuatorExecutor)this.applicationModel.getBeanFactory().getBean(ActuatorExecutor.class);
            return actuatorExecutor.execute(command, args);
        }
        return "Invalid command or not enabled";
    }
}

