/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class AwaitingNonWebApplicationListener
implements SmartApplicationListener {
    private static final String[] WEB_APPLICATION_CONTEXT_CLASSES = new String[]{"org.springframework.web.context.WebApplicationContext", "org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext"};
    private static final Logger logger = LoggerFactory.getLogger(AwaitingNonWebApplicationListener.class);
    private static final Class<? extends ApplicationEvent>[] SUPPORTED_APPLICATION_EVENTS = AwaitingNonWebApplicationListener.of(ApplicationReadyEvent.class, ContextClosedEvent.class);
    private final AtomicBoolean awaited = new AtomicBoolean(false);
    private static final Integer UNDEFINED_ID = -1;
    private final AtomicInteger applicationContextId = new AtomicInteger(UNDEFINED_ID);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    private static <T> T[] of(T ... values) {
        return values;
    }

    AtomicBoolean getAwaited() {
        return this.awaited;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ObjectUtils.containsElement((Object[])SUPPORTED_APPLICATION_EVENTS, eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.onApplicationReadyEvent((ApplicationReadyEvent)event);
        }
        if (event instanceof ApplicationFailedEvent) {
            this.awaitAndRelease(((ApplicationFailedEvent)event).getApplicationContext());
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void onApplicationReadyEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        if (!this.isRootApplicationContext((ApplicationContext)applicationContext) || this.isWebApplication((ApplicationContext)applicationContext)) {
            return;
        }
        if (this.applicationContextId.compareAndSet(UNDEFINED_ID, applicationContext.hashCode())) {
            this.awaitAndRelease(event.getApplicationContext());
        }
    }

    private void awaitAndRelease(ConfigurableApplicationContext applicationContext) {
        this.await();
        this.releaseOnExit(applicationContext);
    }

    private void releaseOnExit(ConfigurableApplicationContext applicationContext) {
        ApplicationModel applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)applicationContext);
        if (applicationModel == null) {
            return;
        }
        ShutdownHookCallbacks shutdownHookCallbacks = (ShutdownHookCallbacks)applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class);
        if (shutdownHookCallbacks != null) {
            shutdownHookCallbacks.addCallback(this::release);
        }
    }

    private boolean isRootApplicationContext(ApplicationContext applicationContext) {
        return applicationContext.getParent() == null;
    }

    private boolean isWebApplication(ApplicationContext applicationContext) {
        boolean webApplication = false;
        for (String contextClass : WEB_APPLICATION_CONTEXT_CLASSES) {
            if (!AwaitingNonWebApplicationListener.isAssignable(contextClass, applicationContext.getClass(), applicationContext.getClassLoader())) continue;
            webApplication = true;
            break;
        }
        return webApplication;
    }

    private static boolean isAssignable(String target, Class<?> type, ClassLoader classLoader) {
        try {
            return ClassUtils.resolveClassName((String)target, (ClassLoader)classLoader).isAssignableFrom(type);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    protected void await() {
        if (this.awaited.get()) {
            return;
        }
        if (!this.executorService.isShutdown()) {
            this.executorService.execute(() -> this.executeMutually(() -> {
                while (!this.awaited.get()) {
                    if (logger.isInfoEnabled()) {
                        logger.info(" [Dubbo] Current Spring Boot Application is await...");
                    }
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }));
        }
    }

    protected void release() {
        this.executeMutually(() -> {
            while (this.awaited.compareAndSet(false, true)) {
                if (logger.isInfoEnabled()) {
                    logger.info(" [Dubbo] Current Spring Boot Application is about to shutdown...");
                }
                this.condition.signalAll();
                this.shutdown();
            }
        });
    }

    private void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

