/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import java.util.function.Function;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.spring.context.properties.AbstractDubboConfigBinder;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;

class BinderDubboConfigBinder
extends AbstractDubboConfigBinder {
    BinderDubboConfigBinder() {
    }

    public <C extends AbstractConfig> void bind(String prefix, C dubboConfig) {
        Iterable propertySources = this.getPropertySources();
        Iterable configurationPropertySources = ConfigurationPropertySources.from((Iterable)propertySources);
        Bindable bindable = Bindable.ofInstance(dubboConfig);
        Binder binder = new Binder(configurationPropertySources, (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver(propertySources));
        BindHandler bindHandler = this.getBindHandler();
        binder.bind(prefix, bindable, bindHandler);
    }

    private BindHandler getBindHandler() {
        BindHandler handler = BindHandler.DEFAULT;
        if (this.isIgnoreInvalidFields()) {
            handler = new IgnoreErrorsBindHandler(handler);
        }
        if (!this.isIgnoreUnknownFields()) {
            UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
            handler = new NoUnboundElementsBindHandler(handler, (Function)filter);
        }
        return handler;
    }
}

