/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure.observability.otlp;

import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.Map;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.spring.boot.autoconfigure.DubboConfigurationProperties;
import org.apache.dubbo.spring.boot.autoconfigure.observability.annotation.ConditionalOnDubboTracingEnable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@AutoConfiguration
@ConditionalOnClass(value={OtelTracer.class, SdkTracerProvider.class, OpenTelemetry.class, OtlpGrpcSpanExporter.class})
@ConditionalOnDubboTracingEnable
@EnableConfigurationProperties(value={DubboConfigurationProperties.class})
public class OtlpAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="dubbo.tracing.tracing-exporter.otlp-config", name={"endpoint"})
    @ConditionalOnMissingBean(value={OtlpGrpcSpanExporter.class}, type={"io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter"})
    OtlpGrpcSpanExporter otlpGrpcSpanExporter(DubboConfigurationProperties properties) {
        ExporterConfig.OtlpConfig cfg = properties.getTracing().getTracingExporter().getOtlpConfig();
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder().setEndpoint(cfg.getEndpoint()).setTimeout(cfg.getTimeout()).setCompression(cfg.getCompressionMethod());
        for (Map.Entry entry : cfg.getHeaders().entrySet()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }
}

