/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpVersion;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;

final class ServletStreamChannel
implements H2StreamChannel {
    private static final ErrorTypeAwareLogger LOG = LoggerFactory.getErrorTypeAwareLogger(ServletStreamChannel.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final AsyncContext context;

    ServletStreamChannel(HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
        this.request = request;
        this.response = response;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        try {
            if (errorCode == 0L) {
                this.response.getOutputStream().close();
            } else if (errorCode >= 300L && errorCode < 600L) {
                this.response.sendError((int)errorCode);
            } else {
                this.response.sendError(500);
            }
        }
        catch (Throwable t) {
            LOG.error("0-22", "", "", "Failed to close response", t);
        }
        finally {
            this.context.complete();
        }
        return CompletableFuture.completedFuture(null);
    }

    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new Http2OutputMessageFrame((OutputStream)new ByteArrayOutputStream(256), endStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        boolean endStream = ((Http2Header)httpMetadata).isEndStream();
        try {
            HttpHeaders headers = httpMetadata.headers();
            if (endStream) {
                this.response.setTrailerFields(() -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Map.Entry entry : headers.entrySet()) {
                        map.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                    }
                    return map;
                });
            } else {
                for (Map.Entry entry : headers.entrySet()) {
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    if (HttpHeaderNames.STATUS.getName().equals(key)) {
                        this.response.setStatus(Integer.parseInt((String)values.get(0)));
                        continue;
                    }
                    if (values.size() == 1) {
                        this.response.setHeader(key, (String)values.get(0));
                        continue;
                    }
                    int size = values.size();
                    for (int i = 0; i < size; ++i) {
                        this.response.addHeader(key, (String)values.get(i));
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error("0-22", "", "", "Failed to write header", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        boolean endStream = ((Http2OutputMessage)httpOutputMessage).isEndStream();
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)httpOutputMessage.getBody();
            ServletOutputStream out = this.response.getOutputStream();
            if (!HttpVersion.HTTP2.getProtocol().equals(this.request.getProtocol())) {
                this.response.setContentLength(bos.size());
            }
            bos.writeTo((OutputStream)out);
            out.flush();
        }
        catch (Throwable t) {
            LOG.error("0-22", "", "", "Failed to write message", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public SocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved(this.request.getRemoteAddr(), this.request.getRemotePort());
    }

    public SocketAddress localAddress() {
        return InetSocketAddress.createUnresolved(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    public void flush() {
    }
}

