/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2ServerTransportListenerFactory;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHttp2ServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.servlet.jakarta.HttpMetadataAdapter;
import org.apache.dubbo.rpc.protocol.tri.servlet.jakarta.ServletStreamChannel;

public class TripleFilter
implements Filter {
    private static final ErrorTypeAwareLogger LOG = LoggerFactory.getErrorTypeAwareLogger(TripleFilter.class);
    private PathResolver pathResolver;
    private RequestMappingRegistry mappingRegistry;
    private int defaultTimeout;

    public void init(FilterConfig config) {
        FrameworkModel frameworkModel = FrameworkModel.defaultModel();
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
        this.mappingRegistry = (RequestMappingRegistry)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultRequestMappingRegistry.class);
        String timeoutString = config.getInitParameter("timeout");
        this.defaultTimeout = timeoutString == null ? 180000 : Integer.parseInt(timeoutString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest hRequest = (HttpServletRequest)request;
        HttpServletResponse hResponse = (HttpServletResponse)response;
        if (!this.hasServiceMapping(hRequest) && !this.mappingRegistry.exists(hRequest.getRequestURI(), hRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        AsyncContext context = request.startAsync();
        try {
            ByteArrayOutputStream os;
            ServletStreamChannel streamChannel = new ServletStreamChannel(hRequest, hResponse, context);
            Http2TransportListener listener = this.determineHttp2ServerTransportListenerFactory(request.getContentType()).newInstance((H2StreamChannel)streamChannel, ServletExchanger.getUrl(), FrameworkModel.defaultModel());
            context.setTimeout((long)this.resolveTimeout(hRequest, listener instanceof GrpcHttp2ServerTransportListener));
            listener.onMetadata((HttpMetadata)new HttpMetadataAdapter(hRequest));
            try {
                os = new ByteArrayOutputStream(1024);
                StreamUtils.copy((InputStream)request.getInputStream(), (OutputStream)os);
            }
            catch (Throwable t) {
                LOG.error("0-22", "", "", "Failed to read input", t);
                try {
                    hResponse.sendError(400);
                }
                finally {
                    context.complete();
                }
                return;
            }
            listener.onData((HttpInputMessage)new Http2InputMessageFrame((InputStream)new ByteArrayInputStream(os.toByteArray()), true));
        }
        catch (Throwable t) {
            LOG.error("99-0", "", "", "Failed to process request", t);
            try {
                hResponse.sendError(500);
            }
            finally {
                context.complete();
            }
        }
    }

    public void destroy() {
    }

    private boolean hasServiceMapping(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int index = uri.indexOf(47, 1);
        if (index == -1) {
            return false;
        }
        if (uri.indexOf(47, index + 1) != -1) {
            return false;
        }
        String serviceName = uri.substring(1, index);
        String version = request.getHeader(TripleHeaderEnum.SERVICE_VERSION.getHeader());
        String group = request.getHeader(TripleHeaderEnum.SERVICE_GROUP.getHeader());
        String key = URL.buildKey((String)serviceName, (String)group, (String)version);
        Invoker invoker = this.pathResolver.resolve(key);
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT && (invoker = this.pathResolver.resolve(URL.buildKey((String)serviceName, (String)group, (String)"1.0.0"))) == null) {
            return this.pathResolver.resolve(serviceName) != null;
        }
        return true;
    }

    private Http2ServerTransportListenerFactory determineHttp2ServerTransportListenerFactory(String contentType) {
        Set http2ServerTransportListenerFactories = FrameworkModel.defaultModel().getExtensionLoader(Http2ServerTransportListenerFactory.class).getSupportedExtensionInstances();
        for (Http2ServerTransportListenerFactory factory : http2ServerTransportListenerFactories) {
            if (!factory.supportContentType(contentType)) continue;
            return factory;
        }
        return GenericHttp2ServerTransportListenerFactory.INSTANCE;
    }

    private int resolveTimeout(HttpServletRequest request, boolean isGrpc) {
        try {
            if (isGrpc) {
                Long timeout;
                String timeoutString = request.getHeader(GrpcHeaderNames.GRPC_TIMEOUT.getName());
                if (timeoutString != null && (timeout = GrpcUtils.parseTimeoutToMills((String)timeoutString)) != null) {
                    return timeout.intValue() + 2000;
                }
            } else {
                String timeoutString = request.getHeader(TripleHeaderEnum.SERVICE_TIMEOUT.getHeader());
                if (timeoutString != null) {
                    return Integer.parseInt(timeoutString) + 2000;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.defaultTimeout;
    }
}

