/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.Part;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.DummyFilterConfig;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.DummyServletContext;

final class Helper {
    private Helper() {
    }

    static Cookie[] convertCookies(Collection<HttpCookie> hCookies) {
        Cookie[] cookies = new Cookie[hCookies.size()];
        int i = 0;
        for (HttpCookie cookie : hCookies) {
            cookies[i++] = Helper.convert(cookie);
        }
        return cookies;
    }

    static Cookie convert(HttpCookie hCookie) {
        Cookie cookie = new Cookie(hCookie.name(), hCookie.value());
        if (hCookie.domain() != null) {
            cookie.setDomain(hCookie.domain());
        }
        cookie.setMaxAge((int)hCookie.maxAge());
        cookie.setHttpOnly(hCookie.httpOnly());
        cookie.setPath(hCookie.path());
        cookie.setSecure(hCookie.secure());
        return cookie;
    }

    static HttpCookie convert(Cookie sCookie) {
        HttpCookie cookie = new HttpCookie(sCookie.getName(), sCookie.getValue());
        cookie.setDomain(sCookie.getDomain());
        cookie.setMaxAge((long)sCookie.getMaxAge());
        cookie.setHttpOnly(sCookie.isHttpOnly());
        cookie.setPath(sCookie.getPath());
        cookie.setSecure(sCookie.getSecure());
        return cookie;
    }

    public static Part convert(HttpRequest.FileUpload part) {
        return new FileUploadPart(part);
    }

    public static Collection<Part> convertParts(Collection<HttpRequest.FileUpload> parts) {
        if (CollectionUtils.isEmpty(parts)) {
            return Collections.emptyList();
        }
        ArrayList<Part> result = new ArrayList<Part>(parts.size());
        for (HttpRequest.FileUpload part : parts) {
            result.add(Helper.convert(part));
        }
        return result;
    }

    public static ServletContext createDummyServletContext(FrameworkModel frameworkModel) {
        return new DummyServletContext(frameworkModel);
    }

    public static FilterConfig createDummyFilterConfig(String filterName, FrameworkModel frameworkModel, ServletContext servletContext) {
        return new DummyFilterConfig(filterName, frameworkModel, servletContext);
    }

    public static final class FileUploadPart
    implements Part {
        private final HttpRequest.FileUpload fileUpload;

        public FileUploadPart(HttpRequest.FileUpload fileUpload) {
            this.fileUpload = fileUpload;
        }

        public InputStream getInputStream() {
            return this.fileUpload.inputStream();
        }

        public String getContentType() {
            return this.fileUpload.contentType();
        }

        public String getName() {
            return this.fileUpload.name();
        }

        public String getSubmittedFileName() {
            return this.fileUpload.filename();
        }

        public long getSize() {
            return this.fileUpload.size();
        }

        public void write(String fileName) {
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                StreamUtils.copy((InputStream)this.fileUpload.inputStream(), (OutputStream)fos);
            }
            catch (IOException e) {
                throw new RestException((Throwable)e);
            }
        }

        public void delete() {
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }
    }
}

