/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.Http2Header;

public final class HttpMetadataAdapter
implements Http2Header {
    private final HttpServletRequest request;
    private HttpHeaders headers;

    HttpMetadataAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpHeaders headers() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            headers = new HttpHeaders();
            Enumeration en = this.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                ArrayList<String> values = new ArrayList<String>(1);
                Enumeration ven = this.request.getHeaders(key);
                while (ven.hasMoreElements()) {
                    values.add((String)ven.nextElement());
                }
                headers.put(key, values);
            }
            this.headers = headers;
        }
        return headers;
    }

    public String method() {
        return this.request.getMethod();
    }

    public String path() {
        String query = this.request.getQueryString();
        return query == null ? this.request.getRequestURI() : this.request.getRequestURI() + '?' + query;
    }

    public long id() {
        return -1L;
    }

    public boolean isEndStream() {
        return false;
    }
}

