/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpVersion;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

final class ServletStreamChannel
implements H2StreamChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStreamChannel.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final AsyncContext context;
    private boolean isGrpc;

    ServletStreamChannel(HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
        this.request = request;
        this.response = response;
        this.context = context;
    }

    public void setGrpc(boolean isGrpc) {
        this.isGrpc = isGrpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeError(int code, Throwable throwable) {
        block9: {
            if (this.response.isCommitted() && code == TriRpcStatus.Code.DEADLINE_EXCEEDED.code) {
                return;
            }
            try {
                if (this.isGrpc) {
                    this.response.setTrailerFields(() -> {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(TripleHeaderEnum.STATUS_KEY.getHeader(), String.valueOf(code));
                        return map;
                    });
                    return;
                }
                try {
                    if (throwable instanceof HttpStatusException) {
                        this.response.setStatus(((HttpStatusException)throwable).getStatusCode());
                        this.response.getOutputStream().close();
                        break block9;
                    }
                    this.response.sendError(500);
                }
                catch (Throwable t) {
                    LOGGER.info("Failed to send response", t);
                }
            }
            finally {
                this.context.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        if (this.isGrpc) {
            this.writeError(TriRpcStatus.httpStatusToGrpcCode((int)((int)errorCode)).code, null);
            return ServletStreamChannel.completed();
        }
        try {
            if (errorCode == 0L) {
                this.response.getOutputStream().close();
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            if (this.response.isCommitted()) {
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            if (errorCode >= 300L && errorCode < 600L) {
                this.response.sendError((int)errorCode);
            } else {
                this.response.sendError(500);
            }
        }
        catch (Throwable t) {
            LOGGER.info("Failed to close response", t);
        }
        finally {
            this.context.complete();
        }
        return ServletStreamChannel.completed();
    }

    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new Http2OutputMessageFrame((OutputStream)new ByteArrayOutputStream(256), endStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        boolean endStream = ((Http2Header)httpMetadata).isEndStream();
        try {
            HttpHeaders headers = httpMetadata.headers();
            if (endStream) {
                this.response.setTrailerFields(() -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Map.Entry entry : headers.entrySet()) {
                        map.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                    }
                    return map;
                });
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            if (this.response.isCommitted()) {
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (HttpHeaderNames.STATUS.getName().equals(key)) {
                    this.response.setStatus(Integer.parseInt((String)values.get(0)));
                    continue;
                }
                if (values.size() == 1) {
                    this.response.setHeader(key, (String)values.get(0));
                    continue;
                }
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    this.response.addHeader(key, (String)values.get(i));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.info("Failed to write header", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
        return ServletStreamChannel.completed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        boolean endStream = ((Http2OutputMessage)httpOutputMessage).isEndStream();
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)httpOutputMessage.getBody();
            ServletOutputStream out = this.response.getOutputStream();
            if (!HttpVersion.HTTP2.getProtocol().equals(this.request.getProtocol())) {
                this.response.setContentLength(bos.size());
            }
            bos.writeTo((OutputStream)out);
            out.flush();
        }
        catch (Throwable t) {
            LOGGER.info("Failed to write message", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
        return ServletStreamChannel.completed();
    }

    public SocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved(this.request.getRemoteAddr(), this.request.getRemotePort());
    }

    public SocketAddress localAddress() {
        return InetSocketAddress.createUnresolved(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    public void flush() {
    }

    private static CompletableFuture<Void> completed() {
        return CompletableFuture.completedFuture(null);
    }
}

