/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpVersion;
import org.apache.dubbo.remoting.http12.message.DefaultHttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.FileUploadPart;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.HttpSessionFactory;

public class ServletHttpRequestAdapter
extends DefaultHttpRequest
implements HttpServletRequest {
    private final ServletContext servletContext;
    private final HttpSessionFactory sessionFactory;
    private ServletInputStream sis;
    private BufferedReader reader;

    public ServletHttpRequestAdapter(HttpMetadata metadata, HttpChannel channel, ServletContext servletContext, HttpSessionFactory sessionFactory) {
        super(metadata, channel);
        this.servletContext = servletContext;
        this.sessionFactory = sessionFactory;
    }

    public String getAuthType() {
        return this.header("www-authenticate");
    }

    public Cookie[] getCookies() {
        return Helper.convertCookies(this.cookies());
    }

    public long getDateHeader(String name) {
        Date date = this.dateHeader(name);
        return date == null ? -1L : date.getTime();
    }

    public String getHeader(String name) {
        return this.header(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.headerValues(name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerNames());
    }

    public int getIntHeader(String name) {
        String headerValue = this.getHeader(name);
        try {
            return Integer.parseInt(headerValue);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getMethod() {
        return this.method();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return "/";
    }

    public String getQueryString() {
        return this.query();
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        return this.path();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(32);
        String scheme = this.getScheme();
        int port = this.getServerPort();
        url.append(scheme).append("://").append(this.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.path());
        return url;
    }

    public String getServletPath() {
        return this.path();
    }

    public HttpSession getSession(boolean create) {
        if (this.sessionFactory == null) {
            throw new UnsupportedOperationException("No HttpSessionFactory found");
        }
        return this.sessionFactory.getSession(this, create);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) {
        throw new UnsupportedOperationException();
    }

    public void logout() {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() {
        return Helper.convertParts(this.parts());
    }

    public FileUploadPart getPart(String name) {
        return Helper.convert(this.part(name));
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeNames());
    }

    public String getCharacterEncoding() {
        return this.charset();
    }

    public void setCharacterEncoding(String env) {
        this.setCharset(env);
    }

    public int getContentLength() {
        return this.contentLength();
    }

    public long getContentLengthLong() {
        return this.contentLength();
    }

    public String getContentType() {
        return this.contentType();
    }

    public ServletInputStream getInputStream() {
        if (this.sis == null) {
            this.sis = new HttpInputStream(this.inputStream());
        }
        return this.sis;
    }

    public String getParameter(String name) {
        return this.parameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterNames());
    }

    public String[] getParameterValues(String name) {
        List values = this.parameterValues(name);
        return values == null ? null : values.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        Collection paramNames = this.parameterNames();
        if (paramNames.isEmpty()) {
            return Collections.emptyMap();
        }
        Map result = CollectionUtils.newLinkedHashMap((int)paramNames.size());
        for (String paramName : paramNames) {
            result.put(paramName, this.getParameterValues(paramName));
        }
        return result;
    }

    public String getProtocol() {
        return this.isHttp2() ? HttpVersion.HTTP2.getProtocol() : HttpVersion.HTTP1.getProtocol();
    }

    public String getScheme() {
        return this.scheme();
    }

    public String getServerName() {
        return this.serverName();
    }

    public int getServerPort() {
        return this.serverPort();
    }

    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.inputStream(), this.charsetOrDefault()));
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.remoteAddr();
    }

    public String getRemoteHost() {
        return String.valueOf(this.remotePort());
    }

    public Locale getLocale() {
        return this.locale();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales());
    }

    public boolean isSecure() {
        return "https".equals(this.scheme());
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        return this.remotePort();
    }

    public String getLocalName() {
        return this.localHost();
    }

    public String getLocalAddr() {
        return this.localAddr();
    }

    public int getLocalPort() {
        return this.localPort();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new IllegalStateException();
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getRequestId() {
        return "";
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }

    public String toString() {
        return "ServletHttpRequestAdapter{" + this.fieldToString() + '}';
    }

    private static final class HttpInputStream
    extends ServletInputStream {
        private final InputStream is;

        HttpInputStream(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public void close() throws IOException {
            this.is.close();
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public boolean isFinished() {
            try {
                return this.is.available() == 0;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }
}

