/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.extension.rest.annotation.processing;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.apache.dubbo.metadata.annotation.processing.builder.MethodDefinitionBuilder;
import org.apache.dubbo.metadata.annotation.processing.util.ExecutableElementComparator;
import org.apache.dubbo.metadata.annotation.processing.util.LoggerUtils;
import org.apache.dubbo.metadata.annotation.processing.util.MethodUtils;
import org.apache.dubbo.metadata.annotation.processing.util.ServiceAnnotationUtils;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.extension.rest.annotation.processing.AnnotatedMethodParameterProcessor;
import org.apache.dubbo.metadata.extension.rest.annotation.processing.ServiceRestMetadataResolver;
import org.apache.dubbo.metadata.extension.rest.api.RequestMetadata;
import org.apache.dubbo.metadata.extension.rest.api.RestMethodMetadata;
import org.apache.dubbo.metadata.extension.rest.api.ServiceRestMetadata;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractServiceRestMetadataResolver
implements ServiceRestMetadataResolver {
    private static final ThreadLocal<Map<String, Object>> threadLocalCache = ThreadLocal.withInitial(HashMap::new);
    private static final Map<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = AbstractServiceRestMetadataResolver.loadAnnotatedMethodParameterProcessors();
    private final String processorName = this.getClass().getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServiceRestMetadata resolve(ProcessingEnvironment processingEnv, TypeElement serviceType, Set<? extends TypeElement> annotations) {
        LoggerUtils.info((String)"%s is processing the service type[%s] with annotations[%s]", (Object[])new Object[]{this.processorName, serviceType, annotations.stream().map(t -> "@" + t.toString()).collect(Collectors.joining(","))});
        ServiceRestMetadata serviceRestMetadata = new ServiceRestMetadata();
        Elements elements = processingEnv.getElementUtils();
        try {
            AnnotationMirror serviceAnnotation = ServiceAnnotationUtils.getAnnotation((TypeElement)serviceType);
            String serviceInterfaceName = ServiceAnnotationUtils.resolveServiceInterfaceName((TypeElement)serviceType, (AnnotationMirror)serviceAnnotation);
            serviceRestMetadata.setServiceInterface(serviceInterfaceName);
            serviceRestMetadata.setGroup(ServiceAnnotationUtils.getGroup((AnnotationMirror)serviceAnnotation));
            serviceRestMetadata.setVersion(ServiceAnnotationUtils.getVersion((AnnotationMirror)serviceAnnotation));
            TypeElement serviceInterfaceType = elements.getTypeElement(serviceInterfaceName);
            LinkedList serviceMethods = new LinkedList(MethodUtils.getPublicNonStaticMethods((TypeElement)serviceInterfaceType, (Type[])new Type[]{Object.class}));
            Collections.sort(serviceMethods, ExecutableElementComparator.INSTANCE);
            serviceMethods.forEach(serviceMethod -> this.resolveRestMethodMetadata(processingEnv, serviceType, serviceInterfaceType, (ExecutableElement)serviceMethod, serviceRestMetadata).ifPresent(serviceRestMetadata.getMeta()::add));
        }
        finally {
            AbstractServiceRestMetadataResolver.clearCache();
        }
        LoggerUtils.info((String)"The %s's process result : %s", (Object[])new Object[]{this.processorName, serviceRestMetadata});
        return serviceRestMetadata;
    }

    protected Optional<RestMethodMetadata> resolveRestMethodMetadata(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement serviceMethod, ServiceRestMetadata serviceRestMetadata) {
        ExecutableElement restCapableMethod = this.findRestCapableMethod(processingEnv, serviceType, serviceInterfaceType, serviceMethod);
        if (restCapableMethod == null) {
            return Optional.empty();
        }
        String requestPath = this.resolveRequestPath(processingEnv, serviceType, restCapableMethod);
        if (requestPath == null) {
            return Optional.empty();
        }
        String requestMethod = this.resolveRequestMethod(processingEnv, serviceType, restCapableMethod);
        if (requestMethod == null) {
            return Optional.empty();
        }
        RestMethodMetadata metadata = new RestMethodMetadata();
        MethodDefinition methodDefinition = this.resolveMethodDefinition(processingEnv, serviceType, restCapableMethod);
        metadata.setMethod(methodDefinition);
        this.processAnnotatedMethodParameters(restCapableMethod, serviceType, metadata);
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        this.processProduces(processingEnv, serviceType, restCapableMethod, produces);
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        this.processConsumes(processingEnv, serviceType, restCapableMethod, consumes);
        RequestMetadata request = metadata.getRequest();
        request.setPath(requestPath);
        request.appendContextPathFromUrl(serviceRestMetadata.getContextPathFromUrl());
        request.setMethod(requestMethod);
        request.setProduces(produces);
        request.setConsumes(consumes);
        this.postProcessRestMethodMetadata(processingEnv, serviceType, serviceMethod, metadata);
        return Optional.of(metadata);
    }

    private ExecutableElement findRestCapableMethod(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement serviceMethod) {
        ExecutableElement overrideMethod = MethodUtils.getOverrideMethod((ProcessingEnvironment)processingEnv, (TypeElement)serviceType, (ExecutableElement)serviceMethod);
        if (this.supports(processingEnv, serviceType, serviceInterfaceType, overrideMethod)) {
            return overrideMethod;
        }
        return this.supports(processingEnv, serviceType, serviceInterfaceType, serviceMethod) ? serviceMethod : null;
    }

    protected abstract boolean supports(ProcessingEnvironment var1, TypeElement var2, TypeElement var3, ExecutableElement var4);

    protected void postProcessRestMethodMetadata(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, RestMethodMetadata metadata) {
    }

    protected abstract String resolveRequestPath(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3);

    protected abstract String resolveRequestMethod(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3);

    protected MethodDefinition resolveMethodDefinition(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        return MethodDefinitionBuilder.build((ProcessingEnvironment)processingEnv, (ExecutableElement)method, new HashMap());
    }

    protected void processAnnotatedMethodParameters(ExecutableElement method, TypeElement type, RestMethodMetadata metadata) {
        List<? extends VariableElement> methodParameters = method.getParameters();
        int size = methodParameters.size();
        for (int i = 0; i < size; ++i) {
            VariableElement parameter = methodParameters.get(i);
            metadata.addIndexToName(i, parameter.getSimpleName().toString());
            this.processAnnotatedMethodParameter(parameter, i, method, type, metadata);
        }
    }

    protected void processAnnotatedMethodParameter(VariableElement parameter, int parameterIndex, ExecutableElement method, TypeElement serviceType, RestMethodMetadata metadata) {
        parameter.getAnnotationMirrors().forEach(annotation -> {
            String annotationType = annotation.getAnnotationType().toString();
            parameterProcessorsMap.getOrDefault(annotationType, Collections.emptyList()).forEach(parameterProcessor -> parameterProcessor.process((AnnotationMirror)annotation, parameter, parameterIndex, method, metadata));
        });
    }

    protected abstract void processProduces(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3, Set<String> var4);

    protected abstract void processConsumes(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3, Set<String> var4);

    protected static final void put(String name, Object value) {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        cache.put(name, value);
    }

    protected static final <T> T get(String name) throws ClassCastException {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        return (T)cache.get(name);
    }

    protected static final <V> V computeIfAbsent(String name, Function<? super String, ? extends V> mappingFunction) {
        return AbstractServiceRestMetadataResolver.getCache().computeIfAbsent(name, mappingFunction);
    }

    private static Map<String, List<AnnotatedMethodParameterProcessor>> loadAnnotatedMethodParameterProcessors() {
        LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = new LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>>();
        ApplicationModel.defaultModel().getExtensionLoader(AnnotatedMethodParameterProcessor.class).getSupportedExtensionInstances().forEach(processor -> {
            List processors = parameterProcessorsMap.computeIfAbsent(processor.getAnnotationType(), k -> new LinkedList());
            processors.add(processor);
        });
        return parameterProcessorsMap;
    }

    private static Map<String, Object> getCache() {
        return threadLocalCache.get();
    }

    private static void clearCache() {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        cache.clear();
        threadLocalCache.remove();
    }
}

