/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.extension.rest.annotation.processing;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.apache.dubbo.metadata.annotation.processing.AbstractServiceAnnotationProcessor;
import org.apache.dubbo.metadata.annotation.processing.util.ServiceAnnotationUtils;
import org.apache.dubbo.metadata.extension.rest.annotation.processing.ServiceRestMetadataResolver;
import org.apache.dubbo.metadata.extension.rest.annotation.processing.ServiceRestMetadataStorage;
import org.apache.dubbo.metadata.extension.rest.api.ServiceRestMetadata;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceRestMetadataAnnotationProcessor
extends AbstractServiceAnnotationProcessor {
    private Set<ServiceRestMetadataResolver> metadataProcessors;
    private ServiceRestMetadataStorage serviceRestMetadataWriter;
    private Set<ServiceRestMetadata> serviceRestMetadata = new LinkedHashSet<ServiceRestMetadata>();

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.metadataProcessors = ApplicationModel.defaultModel().getExtensionLoader(ServiceRestMetadataResolver.class).getSupportedExtensionInstances();
        this.serviceRestMetadataWriter = new ServiceRestMetadataStorage(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ElementFilter.typesIn(roundEnv.getRootElements()).forEach(serviceType -> this.process(this.processingEnv, (TypeElement)serviceType, annotations));
        if (roundEnv.processingOver()) {
            try {
                this.serviceRestMetadataWriter.append(this.serviceRestMetadata);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    private void process(ProcessingEnvironment processingEnv, TypeElement serviceType, Set<? extends TypeElement> annotations) {
        this.metadataProcessors.stream().filter(processor -> this.supports((ServiceRestMetadataResolver)processor, processingEnv, serviceType)).map(processor -> processor.resolve(processingEnv, serviceType, annotations)).forEach(this.serviceRestMetadata::add);
    }

    private boolean supports(ServiceRestMetadataResolver processor, ProcessingEnvironment processingEnv, TypeElement serviceType) {
        return ServiceAnnotationUtils.isServiceAnnotationPresent((TypeElement)serviceType) && processor.supports(processingEnv, serviceType);
    }
}

