/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.extension.rest.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class RequestMetadata
implements Serializable {
    private static final long serialVersionUID = -240099840085329958L;
    private String method;
    private String path;
    private Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();
    private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    private Set<String> consumes = new LinkedHashSet<String>();
    private Set<String> produces = new LinkedHashSet<String>();

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method == null ? null : method.toUpperCase();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = PathUtils.normalize((String)path);
        if (!path.startsWith(StringUtils.SLASH)) {
            this.path = StringUtils.SLASH + path;
        }
    }

    public Map<String, List<String>> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public void setParams(Map<String, List<String>> params) {
        this.params(params);
    }

    private static void add(Map<String, List<String>> multiValueMap, String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        List<String> values = RequestMetadata.get(multiValueMap, key, true);
        values.add(value);
    }

    private static <T extends Collection<String>> void addAll(Map<String, List<String>> multiValueMap, Map<String, T> source) {
        for (Map.Entry<String, T> entry : source.entrySet()) {
            String key = entry.getKey();
            for (String value : (Collection)entry.getValue()) {
                RequestMetadata.add(multiValueMap, key, value);
            }
        }
    }

    private static String getFirst(Map<String, List<String>> multiValueMap, String key) {
        List<String> values = RequestMetadata.get(multiValueMap, key);
        return CollectionUtils.isNotEmpty(values) ? values.get(0) : null;
    }

    private static List<String> get(Map<String, List<String>> multiValueMap, String key) {
        return RequestMetadata.get(multiValueMap, key, false);
    }

    private static List<String> get(Map<String, List<String>> multiValueMap, String key, boolean createIfAbsent) {
        return createIfAbsent ? multiValueMap.computeIfAbsent(key, k -> new LinkedList()) : multiValueMap.get(key);
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers(headers);
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    public Set<String> getParamNames() {
        return new HashSet<String>(this.params.keySet());
    }

    public Set<String> getHeaderNames() {
        return new HashSet<String>(this.headers.keySet());
    }

    public String getParameter(String name) {
        return RequestMetadata.getFirst(this.params, name);
    }

    public String getHeader(String name) {
        return RequestMetadata.getFirst(this.headers, name);
    }

    public RequestMetadata addParam(String name, String value) {
        RequestMetadata.add(this.params, name, value);
        return this;
    }

    public RequestMetadata addHeader(String name, String value) {
        RequestMetadata.add(this.headers, name, value);
        return this;
    }

    private <T extends Collection<String>> RequestMetadata params(Map<String, T> params) {
        RequestMetadata.addAll(this.params, params);
        return this;
    }

    private <T extends Collection<String>> RequestMetadata headers(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            LinkedHashMap<String, List<String>> httpHeaders = new LinkedHashMap<String, List<String>>();
            RequestMetadata.addAll(httpHeaders, headers);
            this.headers.putAll(httpHeaders);
        }
        return this;
    }

    public void appendContextPathFromUrl(String contextPathFromUrl) {
        if (contextPathFromUrl == null) {
            return;
        }
        this.setPath(contextPathFromUrl + this.path);
    }

    public boolean methodAllowed(String method) {
        return method != null && method.equals(this.method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestMetadata)) {
            return false;
        }
        RequestMetadata that = (RequestMetadata)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.consumes, that.consumes) && Objects.equals(this.produces, that.produces) && Objects.equals(this.getParamNames(), that.getParamNames()) && Objects.equals(this.getHeaderNames(), that.getHeaderNames());
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.consumes, this.produces, this.getParamNames(), this.getHeaderNames());
    }

    public String toString() {
        return "RequestMetadata{method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", params=" + this.params + ", headers=" + this.headers + ", consumes=" + this.consumes + ", produces=" + this.produces + '}';
    }
}

