/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.etcd;

import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.remoting.etcd.ChildListener;
import org.apache.dubbo.remoting.etcd.EtcdClient;
import org.apache.dubbo.remoting.etcd.EtcdTransporter;
import org.apache.dubbo.remoting.etcd.option.OptionUtil;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class EtcdServiceDiscovery
extends AbstractServiceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(EtcdServiceDiscovery.class);
    private final String root = "/services";
    private final Set<String> services = new ConcurrentHashSet();
    private final Map<String, InstanceChildListener> childListenerMap = new ConcurrentHashMap<String, InstanceChildListener>();
    EtcdClient etcdClient;

    public EtcdServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        super(applicationModel, registryURL);
        EtcdTransporter etcdTransporter = (EtcdTransporter)applicationModel.getExtensionLoader(EtcdTransporter.class).getAdaptiveExtension();
        if (registryURL.isAnyHost()) {
            throw new IllegalStateException("Service discovery address is invalid, actual: '" + registryURL.getHost() + "'");
        }
        this.etcdClient = etcdTransporter.connect(registryURL);
        this.etcdClient.addStateListener(state -> {
            if (state == 1) {
                try {
                    this.recover();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.registryURL = registryURL;
    }

    protected void doDestroy() throws Exception {
        if (this.etcdClient != null && this.etcdClient.isConnected()) {
            this.etcdClient.close();
        }
    }

    public void doRegister(ServiceInstance serviceInstance) {
        try {
            String path = this.toPath(serviceInstance);
            this.etcdClient.putEphemeral(path, new Gson().toJson((Object)serviceInstance));
            this.services.add(serviceInstance.getServiceName());
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + serviceInstance + " to etcd " + this.etcdClient.getUrl() + ", cause: " + (OptionUtil.isProtocolError((Throwable)e) ? "etcd3 registry may not be supported yet or etcd3 registry is not available." : e.getMessage()), e);
        }
    }

    protected String toPath(ServiceInstance serviceInstance) {
        return "/services" + File.separator + serviceInstance.getServiceName() + File.separator + serviceInstance.getHost() + ":" + serviceInstance.getPort();
    }

    protected String toParentPath(String serviceName) {
        return "/services" + File.separator + serviceName;
    }

    protected void doUnregister(ServiceInstance serviceInstance) {
        try {
            String path = this.toPath(serviceInstance);
            this.etcdClient.delete(path);
            this.services.remove(serviceInstance.getServiceName());
        }
        catch (Throwable e) {
            throw new RpcException("Failed to unregister " + serviceInstance + " to etcd " + this.etcdClient.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    public Set<String> getServices() {
        return Collections.unmodifiableSet(this.services);
    }

    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        for (String serviceName : listener.getServiceNames()) {
            this.registerServiceWatcher(serviceName, listener);
        }
    }

    public List<ServiceInstance> getInstances(String serviceName) {
        List children = this.etcdClient.getChildren(this.toParentPath(serviceName));
        if (CollectionUtils.isEmpty((Collection)children)) {
            return Collections.emptyList();
        }
        ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>(children.size());
        for (String child : children) {
            ServiceInstance serviceInstance = (ServiceInstance)new Gson().fromJson(this.etcdClient.getKVValue(child), DefaultServiceInstance.class);
            list.add(serviceInstance);
        }
        return list;
    }

    protected void registerServiceWatcher(String serviceName, ServiceInstancesChangedListener listener) {
        String path = "/services" + File.separator + serviceName;
        InstanceChildListener childListener = this.childListenerMap.get(serviceName);
        if (childListener == null) {
            childListener = new InstanceChildListener(serviceName);
            this.childListenerMap.put(serviceName, childListener);
            childListener.addListener(listener);
            this.etcdClient.create(path);
            this.etcdClient.addChildListener(path, (ChildListener)childListener);
        } else {
            childListener.addListener(listener);
        }
    }

    public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
        for (String serviceName : listener.getServiceNames()) {
            this.unregisterServiceWatcher(serviceName, listener);
        }
    }

    protected void unregisterServiceWatcher(String serviceName, ServiceInstancesChangedListener listener) {
        String path = "/services" + File.separator + serviceName;
        InstanceChildListener childListener = this.childListenerMap.get(serviceName);
        if (childListener != null) {
            childListener.removeListener(listener);
            if (childListener.getListenerCount() == 0) {
                this.etcdClient.removeChildListener(path, (ChildListener)childListener);
            }
        }
    }

    private void recover() throws Exception {
        if (this.serviceInstance != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Recover application register: " + this.serviceInstance);
            }
            this.doRegister(this.serviceInstance);
        }
    }

    public URL getUrl() {
        return this.registryURL;
    }

    public class InstanceChildListener
    implements ChildListener {
        private final List<ServiceInstancesChangedListener> listeners;
        private final String serviceName;

        public InstanceChildListener(String serviceName) {
            this.serviceName = serviceName;
            this.listeners = new CopyOnWriteArrayList<ServiceInstancesChangedListener>();
        }

        public void childChanged(String path, List<String> children) {
            ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>(children.size());
            for (String child : children) {
                ServiceInstance serviceInstance = (ServiceInstance)new Gson().fromJson(EtcdServiceDiscovery.this.etcdClient.getKVValue(child), DefaultServiceInstance.class);
                list.add(serviceInstance);
            }
            for (ServiceInstancesChangedListener listener : this.listeners) {
                listener.onEvent(new ServiceInstancesChangedEvent(this.serviceName, list));
            }
        }

        public void addListener(ServiceInstancesChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ServiceInstancesChangedListener listener) {
            this.listeners.remove(listener);
        }

        public int getListenerCount() {
            return this.listeners.size();
        }
    }
}

