/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nameservice;

import java.util.Arrays;
import java.util.Objects;
import java.util.zip.CRC32;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public class ServiceName {
    public static final String DEFAULT_PARAM_VALUE = "";
    public static final String NAME_SEPARATOR = "_";
    public static final String VALUE_SEPARATOR = ",";
    public static final String WILDCARD = "*";
    private String category;
    private String serviceInterface;
    private String version;
    private String group;
    private String value;
    private String groupModel;

    public ServiceName() {
    }

    public ServiceName(URL url) {
        this.serviceInterface = url.getParameter("interface");
        this.category = this.isConcrete(this.serviceInterface) ? "providers" : url.getParameter("category");
        this.version = url.getParameter("version", DEFAULT_PARAM_VALUE);
        this.group = url.getParameter("group", DEFAULT_PARAM_VALUE);
        this.groupModel = url.getParameter("groupModel");
        this.value = this.toValue();
    }

    public boolean isConcrete() {
        return this.isConcrete(this.serviceInterface) && this.isConcrete(this.version) && this.isConcrete(this.group);
    }

    public boolean isCompatible(ServiceName serviceName) {
        if (!serviceName.isConcrete()) {
            return false;
        }
        if (!StringUtils.isEquals((String)this.category, (String)serviceName.category) && !this.matchRange(this.category, serviceName.category)) {
            return false;
        }
        if (!StringUtils.isEquals((String)this.serviceInterface, (String)serviceName.serviceInterface)) {
            return false;
        }
        if (this.isWildcard(this.version)) {
            return true;
        }
        if (this.isWildcard(this.group)) {
            return true;
        }
        if (!StringUtils.isEquals((String)this.version, (String)serviceName.version) && !this.matchRange(this.version, serviceName.version)) {
            return false;
        }
        return StringUtils.isEquals((String)this.group, (String)serviceName.group) || this.matchRange(this.group, serviceName.group);
    }

    private boolean matchRange(String range, String value) {
        if (StringUtils.isBlank((CharSequence)range)) {
            return true;
        }
        if (!this.isRange(range)) {
            return false;
        }
        String[] values = range.split(VALUE_SEPARATOR);
        return Arrays.asList(values).contains(value);
    }

    private boolean isConcrete(String value) {
        return !this.isWildcard(value) && !this.isRange(value);
    }

    private boolean isWildcard(String value) {
        return WILDCARD.equals(value);
    }

    private boolean isRange(String value) {
        return value != null && value.contains(VALUE_SEPARATOR) && value.split(VALUE_SEPARATOR).length > 1;
    }

    private String toValue() {
        String value = null;
        value = Objects.equals(this.groupModel, "topic") ? this.category + NAME_SEPARATOR + this.serviceInterface + NAME_SEPARATOR + this.version + NAME_SEPARATOR + this.group : this.category + NAME_SEPARATOR + this.serviceInterface;
        CRC32 crc32 = new CRC32();
        crc32.update(value.getBytes());
        value = value.replace(".", "-") + NAME_SEPARATOR + Long.toString(crc32.getValue());
        return value;
    }

    public String getValue() {
        return this.value;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceName)) {
            return false;
        }
        ServiceName that = (ServiceName)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public String toString() {
        return this.getValue();
    }
}

