/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.extension.rest.api.ArgInfo;
import org.apache.dubbo.metadata.extension.rest.api.ParamType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.BaseConsumerParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.ConsumerParseContext;

@Activate(value={"consumer-parameter"})
public class ParameterConsumerParamParser
implements BaseConsumerParamParser {
    @Override
    public void parse(ConsumerParseContext parseContext, ArgInfo argInfo) {
        List<Object> args = parseContext.getArgs();
        RequestTemplate requestTemplate = parseContext.getRequestTemplate();
        Object paramValue = args.get(argInfo.getIndex());
        if (paramValue == null) {
            return;
        }
        if (Map.class.isAssignableFrom(argInfo.getParamType())) {
            Map paramValues = (Map)paramValue;
            for (Object name : paramValues.keySet()) {
                requestTemplate.addParam(String.valueOf(name), paramValues.get(name));
            }
        } else {
            requestTemplate.addParam(argInfo.getAnnotationNameAttribute(), paramValue);
        }
    }

    @Override
    public boolean paramTypeMatch(ArgInfo argInfo) {
        return ParamType.PARAM.supportAnno(argInfo.getParamAnnotationType());
    }
}

