/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.extension.rest.api.ArgInfo;
import org.apache.dubbo.metadata.extension.rest.api.ParamType;
import org.apache.dubbo.metadata.extension.rest.api.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParseContext;
import org.apache.dubbo.rpc.protocol.rest.exception.ParamParseException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;

@Activate(value={"body"})
public class BodyProviderParamParser
extends ProviderParamParser {
    @Override
    protected void doParse(ProviderParseContext parseContext, ArgInfo argInfo) {
        RequestFacade request = parseContext.getRequestFacade();
        try {
            String contentType = parseContext.getRequestFacade().getHeader(RestHeaderEnum.CONTENT_TYPE.getHeader());
            MediaType mediaType = MediaTypeUtil.convertMediaType(argInfo.getParamType(), contentType);
            Object param = HttpMessageCodecManager.httpMessageDecode(request.getInputStream(), argInfo.getParamType(), argInfo.actualReflectType(), mediaType);
            parseContext.setValueByIndex(argInfo.getIndex(), param);
        }
        catch (Throwable e) {
            throw new ParamParseException("dubbo rest protocol provider body param parser  error: " + e.getMessage());
        }
    }

    @Override
    protected ParamType getParamType() {
        return ParamType.PROVIDER_BODY;
    }
}

