/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.extension.rest.api.ArgInfo;
import org.apache.dubbo.metadata.extension.rest.api.ParamType;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParseContext;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;

@Activate(value={"header"})
public class HeaderProviderParamParser
extends ProviderParamParser {
    @Override
    protected void doParse(ProviderParseContext parseContext, ArgInfo argInfo) {
        RequestFacade request = parseContext.getRequestFacade();
        if (Map.class.isAssignableFrom(argInfo.getParamType())) {
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            Enumeration<String> headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = headerNames.nextElement();
                headerMap.put(name, request.getHeader(name));
            }
            parseContext.setValueByIndex(argInfo.getIndex(), headerMap);
            return;
        }
        String header = request.getHeader(argInfo.getAnnotationNameAttribute());
        Object headerValue = this.paramTypeConvert(argInfo.getParamType(), header);
        parseContext.setValueByIndex(argInfo.getIndex(), headerValue);
    }

    @Override
    protected ParamType getParamType() {
        return ParamType.HEADER;
    }
}

