/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.extension.resteasy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.extension.rest.api.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.filter.DubboContainerResponseContextImpl;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.filter.DubboPreMatchContainerRequestContext;
import org.apache.dubbo.rpc.protocol.rest.filter.ServiceInvokeRestFilter;
import org.apache.dubbo.rpc.protocol.rest.netty.ChunkOutputStream;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;
import org.jboss.resteasy.core.interception.ResponseContainerRequestContext;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyUtil;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public interface ResteasyContext {
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTP = "http";
    public static final String HTTPS_PROTOCOL = "https://";

    default public <T> List<T> getExtension(ServiceDeployer serviceDeployer, Class<T> extension) {
        return serviceDeployer.getExtensions(extension);
    }

    default public DubboPreMatchContainerRequestContext convertHttpRequestToContainerRequestContext(RequestFacade requestFacade, ContainerRequestFilter[] requestFilters) {
        NettyRequestFacade nettyRequestFacade = (NettyRequestFacade)requestFacade;
        HttpRequest request = (HttpRequest)requestFacade.getRequest();
        NettyHttpRequest nettyRequest = this.createNettyHttpRequest(nettyRequestFacade, request);
        if (request instanceof HttpContent) {
            try {
                byte[] inputStream = requestFacade.getInputStream();
                ByteBuf buffer = nettyRequestFacade.getNettyChannelContext().alloc().buffer();
                buffer.writeBytes(inputStream);
                nettyRequest.setContentBuffer(buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new DubboPreMatchContainerRequestContext(nettyRequest, requestFilters, null);
    }

    default public ResteasyUriInfo extractUriInfo(HttpRequest request) {
        String uri;
        String host = HttpHeaders.getHost((HttpMessage)request, (String)"unknown");
        if ("".equals(host)) {
            host = "unknown";
        }
        String uriString = (uri = request.getUri()).startsWith(HTTP_PROTOCOL) || uri.startsWith(HTTPS_PROTOCOL) ? uri : HTTP_PROTOCOL + host + uri;
        URI absoluteURI = URI.create(uriString);
        return new ResteasyUriInfo(uriString, absoluteURI.getRawQuery(), "");
    }

    default public NettyHttpRequest createNettyHttpRequest(NettyRequestFacade nettyRequestFacade, HttpRequest request) {
        ResteasyHttpHeaders headers = NettyUtil.extractHttpHeaders((HttpRequest)request);
        ResteasyUriInfo uriInfo = this.extractUriInfo(request);
        NettyHttpRequest nettyRequest = new NettyHttpRequest(nettyRequestFacade.getNettyChannelContext(), headers, uriInfo, request.getMethod().name(), null, null, HttpHeaders.is100ContinueExpected((HttpMessage)request));
        return nettyRequest;
    }

    default public NettyHttpRequest createNettyHttpRequest(RequestFacade requestFacade) {
        NettyRequestFacade nettyRequestFacade = (NettyRequestFacade)requestFacade;
        HttpRequest request = (HttpRequest)requestFacade.getRequest();
        ResteasyHttpHeaders headers = NettyUtil.extractHttpHeaders((HttpRequest)request);
        ResteasyUriInfo uriInfo = this.extractUriInfo(request);
        NettyHttpRequest nettyRequest = new NettyHttpRequest(nettyRequestFacade.getNettyChannelContext(), headers, uriInfo, request.getMethod().name(), null, null, HttpHeaders.is100ContinueExpected((HttpMessage)request));
        return nettyRequest;
    }

    default public void writeResteasyResponse(URL url, RequestFacade requestFacade, NettyHttpResponse response, BuiltResponse restResponse) throws Exception {
        if (restResponse.getMediaType() != null) {
            MediaType mediaType = MediaTypeUtil.convertMediaType(restResponse.getEntityClass(), restResponse.getMediaType().toString());
            ServiceInvokeRestFilter.writeResult(response, url, restResponse.getEntity(), restResponse.getEntityClass(), mediaType);
        } else {
            ServiceInvokeRestFilter.writeResult(response, requestFacade, url, restResponse.getEntity(), restResponse.getEntityClass());
        }
    }

    default public MediaType getAcceptMediaType(RequestFacade request, Class<?> returnType) {
        return ServiceInvokeRestFilter.getAcceptMediaType(request, returnType);
    }

    default public void addResponseHeaders(NettyHttpResponse response, MultivaluedMap<String, Object> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            for (Object tmp : value) {
                response.addOutputHeaders(key, tmp.toString());
            }
        }
    }

    default public DubboContainerResponseContextImpl createContainerResponseContext(Object originRequest, RequestFacade request, HttpResponse httpResponse, BuiltResponse jaxrsResponse, ContainerResponseFilter[] responseFilters) {
        NettyHttpRequest nettyHttpRequest = originRequest == null ? this.createNettyHttpRequest(request) : (NettyHttpRequest)originRequest;
        ResponseContainerRequestContext requestContext = new ResponseContainerRequestContext((org.jboss.resteasy.spi.HttpRequest)nettyHttpRequest);
        DubboContainerResponseContextImpl responseContext = new DubboContainerResponseContextImpl((org.jboss.resteasy.spi.HttpRequest)nettyHttpRequest, httpResponse, jaxrsResponse, requestContext, responseFilters, null, null);
        return responseContext;
    }

    default public void restOutputStream(NettyHttpResponse response) throws IOException {
        ChunkOutputStream outputStream = (ChunkOutputStream)response.getOutputStream();
        outputStream.reset();
    }
}

