/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.extension.rest.api.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.message.MediaTypeMatcher;
import org.xml.sax.InputSource;

@Activate(value={"xml"})
public class XMLCodec
implements HttpMessageCodec<byte[], OutputStream> {
    @Override
    public Object decode(byte[] body, Class<?> targetType, Type type) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader(new String(body))));
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetType});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller.unmarshal((Source)xmlSource);
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class<?> targetType) {
        return MediaTypeMatcher.TEXT_XML.mediaSupport(mediaType);
    }

    @Override
    public boolean typeSupport(Class<?> targetType) {
        return false;
    }

    @Override
    public MediaType contentType() {
        return MediaType.TEXT_XML;
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{unSerializedBody.getClass()}).createMarshaller();
        marshaller.marshal(unSerializedBody, outputStream);
    }
}

