/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.metadata.extension.rest.api.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.exception.UnSupportContentTypeException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;

public class MediaTypeUtil {
    private static final List<MediaType> mediaTypes = MediaType.getSupportMediaTypes();

    public static MediaType convertMediaType(Class<?> targetType, String ... contentTypes) {
        if (contentTypes == null || contentTypes.length == 0) {
            return HttpMessageCodecManager.typeSupport(targetType);
        }
        for (String contentType : contentTypes) {
            for (MediaType mediaType : mediaTypes) {
                if (contentType == null || !contentType.contains(mediaType.value)) continue;
                return mediaType;
            }
            if (contentType == null || !contentType.contains(MediaType.ALL_VALUE.value)) continue;
            return HttpMessageCodecManager.typeSupport(targetType);
        }
        throw new UnSupportContentTypeException(Arrays.toString(contentTypes));
    }
}

