/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.DefaultJsonDataInput;
import org.apache.dubbo.common.utils.ClassUtils;

public class FastJsonObjectInput
implements DefaultJsonDataInput {
    private InputStream is;

    public FastJsonObjectInput(InputStream in) {
        this.is = in;
    }

    public <T> T readObject(Class<T> cls) throws IOException {
        return this.readObject(cls, null);
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException {
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        ParserConfig parserConfig = new ParserConfig();
        parserConfig.setAutoTypeSupport(true);
        Object result = JSON.parseObject((String)new String(bytes), cls, (ParserConfig)parserConfig, (Feature[])new Feature[]{Feature.SupportNonPublicField, Feature.SupportAutoType});
        if (result != null && cls != null && !ClassUtils.isMatch(result.getClass(), cls)) {
            throw new IllegalArgumentException("deserialize failed. expected class: " + cls + " but actual class: " + result.getClass());
        }
        return (T)result;
    }

    public byte[] readBytes() throws IOException {
        int length = this.is.read();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        return bytes;
    }

    private int readLength() throws IOException {
        byte[] bytes = new byte[4];
        int read = this.is.read(bytes, 0, 4);
        if (read != 4) {
            throw new IllegalArgumentException("deserialize failed. expected read length: 4 but actual read: " + read);
        }
        int value = 0;
        for (byte b : bytes) {
            value = (value << 8) + (b & 0xFF);
        }
        return value;
    }
}

