/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.DefaultJsonDataOutput;

public class FastJsonObjectOutput
implements DefaultJsonDataOutput {
    private OutputStream os;

    public FastJsonObjectOutput(OutputStream out) {
        this.os = out;
    }

    public void writeBytes(byte[] b) throws IOException {
        this.os.write(b.length);
        this.os.write(b);
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.os.write(len);
        this.os.write(b, off, len);
    }

    public void writeObject(Object obj) throws IOException {
        byte[] bytes = JSON.toJSONBytes((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteClassName, SerializerFeature.NotWriteDefaultValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteClassName, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
        this.writeLength(bytes.length);
        this.os.write(bytes);
        this.os.flush();
    }

    private void writeLength(int value) throws IOException {
        byte[] bytes = new byte[4];
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            bytes[length - i - 1] = (byte)(value & 0xFF);
            value >>= 8;
        }
        this.os.write(bytes);
    }

    public void flushBuffer() throws IOException {
        this.os.flush();
    }
}

