/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.gson;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.DefaultJsonDataInput;
import org.apache.dubbo.common.serialize.gson.ExceptionWrapper;
import org.apache.dubbo.common.utils.PojoUtils;

public class GsonJsonObjectInput
implements DefaultJsonDataInput {
    private final BufferedReader reader;
    private Gson gson;

    public GsonJsonObjectInput(InputStream in) {
        this(new InputStreamReader(in));
    }

    public GsonJsonObjectInput(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.gson = new Gson();
    }

    public boolean readBool() throws IOException {
        return this.read(Boolean.TYPE);
    }

    public byte readByte() throws IOException {
        return this.read(Byte.TYPE);
    }

    public short readShort() throws IOException {
        return this.read(Short.TYPE);
    }

    public int readInt() throws IOException {
        return this.read(Integer.TYPE);
    }

    public long readLong() throws IOException {
        return this.read(Long.TYPE);
    }

    public float readFloat() throws IOException {
        return this.read(Float.TYPE).floatValue();
    }

    public double readDouble() throws IOException {
        return this.read(Double.TYPE);
    }

    public String readUTF() throws IOException {
        return this.read(String.class);
    }

    public byte[] readBytes() throws IOException {
        return this.readLine().getBytes();
    }

    public Object readObject() throws IOException {
        return this.readObject(Object.class);
    }

    public <T> T readObject(Class<T> cls) throws IOException {
        String json = this.readLine();
        return (T)this.gson.fromJson(json, cls);
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        T value = this.readObject(cls);
        return (T)PojoUtils.realize(value, cls, (Type)type);
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null || line.trim().length() == 0) {
            throw new EOFException();
        }
        return line;
    }

    private <T> T read(Class<T> cls) throws IOException {
        String json = this.readLine();
        return (T)this.gson.fromJson(json, cls);
    }

    public Throwable readThrowable() throws IOException, ClassNotFoundException {
        ExceptionWrapper obj = this.readObject(ExceptionWrapper.class);
        return (Throwable)this.gson.fromJson(obj.getException().toString(), Class.forName(obj.getClazz()));
    }
}

