/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.gson;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.dubbo.common.serialize.DefaultJsonDataOutput;
import org.apache.dubbo.common.serialize.gson.ExceptionWrapper;

public class GsonJsonObjectOutput
implements DefaultJsonDataOutput {
    private final PrintWriter writer;
    private Gson gson = new Gson();

    public GsonJsonObjectOutput(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public GsonJsonObjectOutput(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void writeBytes(byte[] b) throws IOException {
        this.writer.println(new String(b));
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writer.println(new String(b, off, len));
    }

    public void writeObject(Object obj) throws IOException {
        char[] json = this.gson.toJson(obj).toCharArray();
        this.writer.write(json, 0, json.length);
        this.writer.println();
        this.writer.flush();
        json = null;
    }

    public void writeThrowable(Throwable obj) throws IOException {
        String clazz = obj.getClass().getName();
        ExceptionWrapper bo = new ExceptionWrapper(obj, clazz);
        this.writeObject(bo);
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
    }
}

