/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.DefaultJsonDataInput;

public class JacksonObjectInput
implements DefaultJsonDataInput {
    private final ObjectMapper MAPPER;
    private final BufferedReader READER;

    public JacksonObjectInput(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public JacksonObjectInput(Reader reader) {
        this.READER = new BufferedReader(reader);
        this.MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    }

    public Object readObject() throws IOException {
        return this.readObject(Object.class);
    }

    public <T> T readObject(Class<T> cls) throws IOException {
        String json = this.readLine();
        return (T)this.MAPPER.readValue(json, cls);
    }

    public <T> T readObject(Class<T> cls, final Type type) throws IOException, ClassNotFoundException {
        String json = this.readLine();
        return (T)this.MAPPER.readValue(json, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        });
    }

    public byte[] readBytes() throws IOException {
        return this.readLine().getBytes();
    }

    private String readLine() throws IOException {
        String line = this.READER.readLine();
        if (line == null || line.trim().isEmpty()) {
            throw new EOFException();
        }
        return line;
    }
}

