/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.dubbo.common.serialize.DefaultJsonDataOutput;

public class JacksonObjectOutput
implements DefaultJsonDataOutput {
    private final ObjectMapper MAPPER;
    private final PrintWriter WRITER;

    public JacksonObjectOutput(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public JacksonObjectOutput(Writer writer) {
        this.WRITER = new PrintWriter(writer);
        this.MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    }

    public void writeObject(Object obj) throws IOException {
        char[] jsonChars = this.convertJsonToCharArray(this.MAPPER.writeValueAsString(obj));
        this.WRITER.write(jsonChars, 0, jsonChars.length);
        this.WRITER.println();
        this.WRITER.flush();
    }

    public void writeBytes(byte[] v) throws IOException {
        this.WRITER.println(new String(v));
    }

    public void writeBytes(byte[] v, int off, int len) throws IOException {
        this.WRITER.println(new String(v, off, len));
    }

    public void flushBuffer() throws IOException {
        this.WRITER.flush();
    }

    private char[] convertJsonToCharArray(String json) {
        return json.toCharArray();
    }
}

