/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.jackson;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.jackson.JacksonObjectInput;
import org.apache.dubbo.common.serialize.jackson.JacksonObjectOutput;

public class JacksonSerialization
implements Serialization {
    private static final byte JACKSON_SERIALIZATION_ID = 18;
    private static final String JSON_CONTENT_TYPE = "application/json";

    public byte getContentTypeId() {
        return 18;
    }

    public String getContentType() {
        return JSON_CONTENT_TYPE;
    }

    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        return new JacksonObjectOutput(output);
    }

    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        return new JacksonObjectInput(input);
    }
}

