/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.msgpack;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MsgpackObjectOutput
implements ObjectOutput {
    private OutputStream out;
    private ObjectMapper om;

    public MsgpackObjectOutput(OutputStream out) {
        this.out = out;
        this.om = new ObjectMapper((JsonFactory)new MessagePackFactory());
    }

    public void writeBool(boolean v) throws IOException {
        this.writeObject(v);
    }

    public void writeByte(byte v) throws IOException {
        this.writeObject(v);
    }

    public void writeShort(short v) throws IOException {
        this.writeObject(v);
    }

    public void writeInt(int v) throws IOException {
        this.writeObject(v);
    }

    public void writeLong(long v) throws IOException {
        this.writeObject(v);
    }

    public void writeFloat(float v) throws IOException {
        this.writeObject(Float.valueOf(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeObject(v);
    }

    public void writeUTF(String v) throws IOException {
        this.writeObject(v);
    }

    public void writeBytes(byte[] b) throws IOException {
        this.writeObject(b);
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        byte[] d = Arrays.copyOfRange(b, off, off + len);
        this.writeObject(d);
    }

    public void writeObject(Object obj) throws IOException {
        byte[] bytes = this.om.writeValueAsBytes(obj);
        this.out.write(bytes);
        this.out.flush();
        bytes = null;
    }

    public void writeThrowable(Throwable obj) throws IOException {
        this.writeObject(obj.getClass());
        this.writeObject(obj);
    }

    public void flushBuffer() throws IOException {
        this.out.flush();
    }
}

