/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufAttachmentUtils;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufUtils;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.ThrowablePB;

public class GenericProtobufJsonObjectOutput
implements ObjectOutput {
    private final PrintWriter writer;

    public GenericProtobufJsonObjectOutput(OutputStream out) {
        this.writer = new PrintWriter(new OutputStreamWriter(out));
    }

    public void writeBool(boolean v) throws IOException {
        this.writeObject(BoolValue.newBuilder().setValue(v).build());
    }

    public void writeByte(byte v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    public void writeShort(short v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    public void writeInt(int v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue(v).build());
    }

    public void writeLong(long v) throws IOException {
        this.writeObject(Int64Value.newBuilder().setValue(v).build());
    }

    public void writeFloat(float v) throws IOException {
        this.writeObject(FloatValue.newBuilder().setValue(v).build());
    }

    public void writeDouble(double v) throws IOException {
        this.writeObject(DoubleValue.newBuilder().setValue(v).build());
    }

    public void writeUTF(String v) throws IOException {
        this.writeObject(StringValue.newBuilder().setValue(v).build());
    }

    public void writeBytes(byte[] b) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b)).build());
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b, (int)off, (int)len)).build());
    }

    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            throw new IllegalArgumentException("This serialization only support google protobuf object, the object is : null");
        }
        if (!ProtobufUtils.isSupported(obj.getClass())) {
            throw new IllegalArgumentException("This serialization only support google protobuf object, the object class is: " + obj.getClass().getName());
        }
        this.writer.write(ProtobufUtils.serializeJson(obj));
        this.writer.println();
        this.writer.flush();
    }

    public void writeThrowable(Throwable th) throws IOException {
        if (!ProtobufUtils.isSupported(th.getClass())) {
            ThrowablePB.ThrowableProto throwableProto = ProtobufUtils.convertToThrowableProto(th);
            this.writer.write(ProtobufUtils.serializeJson(throwableProto));
        } else {
            this.writer.write(ProtobufUtils.serializeJson(th));
        }
        this.writer.println();
        this.writer.flush();
    }

    public void writeEvent(String data) throws IOException {
        if (Objects.equals(data, CommonConstants.HEARTBEAT_EVENT)) {
            data = "H";
        }
        this.writeUTF(data);
    }

    public void writeAttachments(Map<String, Object> attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        MapValue.Map map = ProtobufAttachmentUtils.wrap(attachments);
        this.writer.write(ProtobufUtils.serializeJson(map, ProtobufAttachmentUtils.getTypeRegistry()));
        this.writer.println();
        this.writer.flush();
    }

    public void flushBuffer() {
        this.writer.flush();
    }
}

