/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;

public class ProtobufAttachmentUtils {
    private static Map<String, BuiltinMarshaller> marshallers = new HashMap<String, BuiltinMarshaller>();
    private static final String NULL_CLASS_NAME = "null";
    private static final JsonFormat.TypeRegistry typeRegistry;

    static JsonFormat.TypeRegistry getTypeRegistry() {
        return typeRegistry;
    }

    static void marshaller(Class<?> clazz, BuiltinMarshaller marshaller) {
        marshallers.put(clazz.getCanonicalName(), marshaller);
    }

    static MapValue.Map wrap(Map<String, Object> attachments) throws IOException {
        HashMap<String, Any> genericAttachments = new HashMap<String, Any>(attachments.size());
        HashMap<String, String> stringAttachments = new HashMap<String, String>(attachments.size());
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            genericAttachments.put(entry.getKey(), ProtobufAttachmentUtils.marshal(entry.getValue()));
            stringAttachments.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return MapValue.Map.newBuilder().putAllAttachmentsV2(genericAttachments).putAllAttachments(stringAttachments).build();
    }

    static Map<String, Object> unwrap(MapValue.Map map) throws InvalidProtocolBufferException {
        Map<String, Any> genericAttachments;
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        Map<String, String> stringAttachments = map.getAttachmentsMap();
        if (stringAttachments != null) {
            stringAttachments.forEach((k, v) -> attachments.put((String)k, v));
        }
        if ((genericAttachments = map.getAttachmentsV2Map()) == null) {
            return attachments;
        }
        for (Map.Entry<String, Any> entry : genericAttachments.entrySet()) {
            attachments.put(entry.getKey(), ProtobufAttachmentUtils.unmarshal(entry.getValue()));
        }
        return attachments;
    }

    private static Any marshal(Object obj) throws IOException {
        BuiltinMarshaller marshaller;
        String className = NULL_CLASS_NAME;
        if (obj != null) {
            className = obj.getClass().getCanonicalName();
        }
        if ((marshaller = marshallers.get(className)) == null) {
            throw new IllegalStateException(className + " in attachment is not supported by protobuf.");
        }
        MapValue.Attachment attachment = MapValue.Attachment.newBuilder().setType(className).setData(marshaller.marshal(obj)).build();
        return Any.pack((Message)attachment);
    }

    private static Object unmarshal(Any any) throws InvalidProtocolBufferException {
        MapValue.Attachment attachment = (MapValue.Attachment)any.unpack(MapValue.Attachment.class);
        String className = attachment.getType();
        BuiltinMarshaller marshaller = marshallers.get(className);
        if (marshaller == null) {
            throw new IllegalStateException(className + " in attachment is not supported by protobuf.");
        }
        return marshaller.unmarshal(attachment.getData());
    }

    static {
        ProtobufAttachmentUtils.marshaller(String.class, new StringMarshaller());
        ProtobufAttachmentUtils.marshaller(Integer.class, new IntegerMarshaller());
        ProtobufAttachmentUtils.marshaller(Long.class, new LongMarshaller());
        ProtobufAttachmentUtils.marshaller(Boolean.class, new BooleanMarshaller());
        ProtobufAttachmentUtils.marshaller(Float.class, new FloatMarshaller());
        ProtobufAttachmentUtils.marshaller(Double.class, new DoubleMarshaller());
        marshallers.put(NULL_CLASS_NAME, new NullMarshaller());
        typeRegistry = JsonFormat.TypeRegistry.newBuilder().add(StringValue.getDescriptor()).add(Int32Value.getDescriptor()).add(Int64Value.getDescriptor()).add(BoolValue.getDescriptor()).add(FloatValue.getDescriptor()).add(DoubleValue.getDescriptor()).add(Empty.getDescriptor()).add(MapValue.Attachment.getDescriptor()).build();
    }

    static class NullMarshaller
    implements BuiltinMarshaller<Object> {
        NullMarshaller() {
        }

        @Override
        public Any marshal(Object obj) throws IOException {
            return Any.pack((Message)Empty.newBuilder().build());
        }

        @Override
        public Object unmarshal(Any any) throws InvalidProtocolBufferException {
            return null;
        }
    }

    static class DoubleMarshaller
    implements BuiltinMarshaller<Double> {
        DoubleMarshaller() {
        }

        @Override
        public Any marshal(Double obj) throws IOException {
            return Any.pack((Message)DoubleValue.newBuilder().setValue(obj.doubleValue()).build());
        }

        @Override
        public Double unmarshal(Any any) throws InvalidProtocolBufferException {
            return ((DoubleValue)any.unpack(DoubleValue.class)).getValue();
        }
    }

    static class FloatMarshaller
    implements BuiltinMarshaller<Float> {
        FloatMarshaller() {
        }

        @Override
        public Any marshal(Float obj) throws IOException {
            return Any.pack((Message)FloatValue.newBuilder().setValue(obj.floatValue()).build());
        }

        @Override
        public Float unmarshal(Any any) throws InvalidProtocolBufferException {
            return Float.valueOf(((FloatValue)any.unpack(FloatValue.class)).getValue());
        }
    }

    static class BooleanMarshaller
    implements BuiltinMarshaller<Boolean> {
        BooleanMarshaller() {
        }

        @Override
        public Any marshal(Boolean obj) throws IOException {
            return Any.pack((Message)BoolValue.newBuilder().setValue(obj.booleanValue()).build());
        }

        @Override
        public Boolean unmarshal(Any any) throws InvalidProtocolBufferException {
            return ((BoolValue)any.unpack(BoolValue.class)).getValue();
        }
    }

    static class LongMarshaller
    implements BuiltinMarshaller<Long> {
        LongMarshaller() {
        }

        @Override
        public Any marshal(Long obj) throws IOException {
            return Any.pack((Message)Int64Value.newBuilder().setValue(obj.longValue()).build());
        }

        @Override
        public Long unmarshal(Any any) throws InvalidProtocolBufferException {
            return ((Int64Value)any.unpack(Int64Value.class)).getValue();
        }
    }

    static class IntegerMarshaller
    implements BuiltinMarshaller<Integer> {
        IntegerMarshaller() {
        }

        @Override
        public Any marshal(Integer obj) throws IOException {
            return Any.pack((Message)Int32Value.newBuilder().setValue(obj.intValue()).build());
        }

        @Override
        public Integer unmarshal(Any any) throws InvalidProtocolBufferException {
            return ((Int32Value)any.unpack(Int32Value.class)).getValue();
        }
    }

    static class StringMarshaller
    implements BuiltinMarshaller<String> {
        StringMarshaller() {
        }

        @Override
        public Any marshal(String obj) throws IOException {
            return Any.pack((Message)StringValue.newBuilder().setValue(obj).build());
        }

        @Override
        public String unmarshal(Any any) throws InvalidProtocolBufferException {
            return ((StringValue)any.unpack(StringValue.class)).getValue();
        }
    }

    private static interface BuiltinMarshaller<T> {
        public Any marshal(T var1) throws IOException;

        public T unmarshal(Any var1) throws InvalidProtocolBufferException;
    }
}

