/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.socket;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;

public class Inet6AddressDeserializer
extends AbstractDeserializer {
    @Override
    public Class<?> getType() {
        return InetAddress.class;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.Inet6Address:" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            Inet6Address inet6Address = (Inet6Address)Inet6Address.getByAddress("", new byte[16]);
            InetAddress inet4Address = null;
            for (String fieldName : fieldNames) {
                if ("holder6".equals(fieldName)) {
                    inet6Address = (Inet6Address)in.readObject();
                }
                if (!"holder".equals(fieldName)) continue;
                inet4Address = (InetAddress)in.readObject();
            }
            if (inet4Address != null) {
                inet6Address = Inet6Address.getByAddress(inet4Address.getHostName(), inet6Address.getAddress(), inet6Address.getScopeId() <= 0 ? -1 : inet6Address.getScopeId());
            }
            in.addRef(inet6Address);
            return inet6Address;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.Inet6Address:" + e, e);
        }
    }
}

