/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.FieldDeserializer2;
import com.alibaba.com.caucho.hessian.io.FieldDeserializer2Factory;
import com.alibaba.com.caucho.hessian.io.HessianFieldException;
import com.alibaba.com.caucho.hessian.io.JavaDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class FieldDeserializer2FactoryUnsafe
extends FieldDeserializer2Factory {
    private static final Logger log = Logger.getLogger(JavaDeserializer.class.getName());
    private static boolean _isEnabled;
    private static Unsafe _unsafe;
    static final Map<String, Boolean> PRIMITIVE_TYPE;

    static void logDeserializeError(Field field, Object obj, Object value, Throwable e) throws IOException {
        String fieldName = field.getDeclaringClass().getName() + "." + field.getName();
        if (e instanceof HessianFieldException) {
            throw (HessianFieldException)e;
        }
        if (e instanceof IOException) {
            throw new HessianFieldException(fieldName + ": " + e.getMessage(), e);
        }
        if (value != null) {
            throw new HessianFieldException(fieldName + ": " + value.getClass().getName() + " cannot be assigned to '" + field.getType().getName() + "'", e);
        }
        throw new HessianFieldException(fieldName + ": " + field.getType().getName() + " cannot be assigned from null", e);
    }

    @Override
    public FieldDeserializer2 create(Field field) {
        if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return NullFieldDeserializer.DESER;
        }
        Class<?> type = field.getType();
        FieldDeserializer2 deser = String.class.equals(type) ? new StringFieldDeserializer(field) : (Byte.TYPE.equals(type) ? new ByteFieldDeserializer(field) : (Character.TYPE.equals(type) ? new CharFieldDeserializer(field) : (Short.TYPE.equals(type) ? new ShortFieldDeserializer(field) : (Integer.TYPE.equals(type) ? new IntFieldDeserializer(field) : (Long.TYPE.equals(type) ? new LongFieldDeserializer(field) : (Float.TYPE.equals(type) ? new FloatFieldDeserializer(field) : (Double.TYPE.equals(type) ? new DoubleFieldDeserializer(field) : (Boolean.TYPE.equals(type) ? new BooleanFieldDeserializer(field) : (Date.class.equals(type) ? new SqlDateFieldDeserializer(field) : (Timestamp.class.equals(type) ? new SqlTimestampFieldDeserializer(field) : (Time.class.equals(type) ? new SqlTimeFieldDeserializer(field) : (Map.class.equals(type) && field.getGenericType() != field.getType() ? new ObjectMapFieldDeserializer(field) : (List.class.equals(type) && field.getGenericType() != field.getType() ? new ObjectListFieldDeserializer(field) : (Set.class.equals(type) && field.getGenericType() != field.getType() ? new ObjectSetFieldDeserializer(field) : new ObjectFieldDeserializer(field)))))))))))))));
        return deser;
    }

    private static boolean isPrimitive(Type type) {
        try {
            if (type != null && type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.isPrimitive() || PRIMITIVE_TYPE.containsKey(clazz.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        boolean isEnabled = false;
        try {
            Class<?> unsafe = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = null;
            for (Field field : unsafe.getDeclaredFields()) {
                if (!field.getName().equals("theUnsafe")) continue;
                theUnsafe = field;
            }
            if (theUnsafe != null) {
                theUnsafe.setAccessible(true);
                _unsafe = (Unsafe)theUnsafe.get(null);
            }
            isEnabled = _unsafe != null;
            String unsafeProp = System.getProperty("com.caucho.hessian.unsafe");
            if ("false".equals(unsafeProp)) {
                isEnabled = false;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _isEnabled = isEnabled;
        PRIMITIVE_TYPE = new HashMap<String, Boolean>(){
            {
                this.put(Boolean.class.getName(), true);
                this.put(Character.class.getName(), true);
                this.put(Byte.class.getName(), true);
                this.put(Short.class.getName(), true);
                this.put(Integer.class.getName(), true);
                this.put(Long.class.getName(), true);
                this.put(Float.class.getName(), true);
                this.put(Double.class.getName(), true);
                this.put(Void.class.getName(), true);
            }
        };
    }

    static class ObjectSetFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ObjectSetFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = null;
            try {
                Type[] types = ((ParameterizedType)this._field.getGenericType()).getActualTypeArguments();
                value = in.readObject(this._field.getType(), FieldDeserializer2FactoryUnsafe.isPrimitive(types[0]) ? (Class)types[0] : null);
                _unsafe.putObject(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ObjectListFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ObjectListFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = null;
            try {
                Type[] types = ((ParameterizedType)this._field.getGenericType()).getActualTypeArguments();
                value = in.readObject(this._field.getType(), FieldDeserializer2FactoryUnsafe.isPrimitive(types[0]) ? (Class)types[0] : null);
                _unsafe.putObject(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ObjectMapFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ObjectMapFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = null;
            try {
                Type[] types = ((ParameterizedType)this._field.getGenericType()).getActualTypeArguments();
                value = in.readObject(this._field.getType(), FieldDeserializer2FactoryUnsafe.isPrimitive(types[0]) ? (Class)types[0] : null, FieldDeserializer2FactoryUnsafe.isPrimitive(types[1]) ? (Class)types[1] : null);
                _unsafe.putObject(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class SqlTimeFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        SqlTimeFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Time value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Time(date.getTime());
                    _unsafe.putObject(obj, this._offset, value);
                } else {
                    _unsafe.putObject(obj, this._offset, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class SqlTimestampFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        SqlTimestampFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Timestamp value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Timestamp(date.getTime());
                    _unsafe.putObject(obj, this._offset, value);
                } else {
                    _unsafe.putObject(obj, this._offset, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class SqlDateFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        SqlDateFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Date value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Date(date.getTime());
                    _unsafe.putObject(obj, this._offset, value);
                } else {
                    _unsafe.putObject(obj, this._offset, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class StringFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        StringFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            String value = null;
            try {
                value = in.readString();
                _unsafe.putObject(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class DoubleFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        DoubleFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = 0.0;
            try {
                value = in.readDouble();
                _unsafe.putDouble(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class FloatFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        FloatFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = 0.0;
            try {
                value = in.readDouble();
                _unsafe.putDouble(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class LongFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        LongFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            long value = 0L;
            try {
                value = in.readLong();
                _unsafe.putLong(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class IntFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        IntFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                _unsafe.putInt(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ShortFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ShortFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                _unsafe.putShort(obj, this._offset, (short)value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class CharFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        CharFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            String value = null;
            try {
                value = in.readString();
                char ch = value != null && value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                _unsafe.putChar(obj, this._offset, ch);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ByteFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ByteFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                _unsafe.putByte(obj, this._offset, (byte)value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class BooleanFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        BooleanFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            boolean value = false;
            try {
                value = in.readBoolean();
                _unsafe.putBoolean(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ObjectFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;
        private final long _offset;

        ObjectFieldDeserializer(Field field) {
            this._field = field;
            this._offset = _unsafe.objectFieldOffset(this._field);
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = null;
            try {
                value = in.readObject(this._field.getType());
                _unsafe.putObject(obj, this._offset, value);
            }
            catch (Exception e) {
                FieldDeserializer2FactoryUnsafe.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class NullFieldDeserializer
    implements FieldDeserializer2 {
        static NullFieldDeserializer DESER = new NullFieldDeserializer();

        NullFieldDeserializer() {
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            in.readObject();
        }
    }
}

